/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.operator.bc;

import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.crypto.InvalidCipherTextException;
import com.koalii.kgsp.bc.crypto.Wrapper;
import com.koalii.kgsp.bc.crypto.params.KeyParameter;
import com.koalii.kgsp.bc.operator.GenericKey;
import com.koalii.kgsp.bc.operator.OperatorException;
import com.koalii.kgsp.bc.operator.SymmetricKeyUnwrapper;
import java.security.SecureRandom;

public class BcSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyUnwrapper(AlgorithmIdentifier wrappingAlgorithm, Wrapper wrapper, KeyParameter wrappingKey) {
        super(wrappingAlgorithm);
        this.wrapper = wrapper;
        this.wrappingKey = wrappingKey;
    }

    public BcSymmetricKeyUnwrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        this.wrapper.init(false, this.wrappingKey);
        try {
            return new GenericKey(encryptedKeyAlgorithm, this.wrapper.unwrap(encryptedKey, 0, encryptedKey.length));
        }
        catch (InvalidCipherTextException e) {
            throw new OperatorException("unable to unwrap key: " + e.getMessage(), e);
        }
    }
}

