/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.operator.bc;

import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.kgsp.bc.crypto.ExtendedDigest;
import com.koalii.kgsp.bc.crypto.Signer;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.signers.DSADigestSigner;
import com.koalii.kgsp.bc.crypto.signers.DSASigner;
import com.koalii.kgsp.bc.crypto.util.PublicKeyFactory;
import com.koalii.kgsp.bc.operator.DigestAlgorithmIdentifierFinder;
import com.koalii.kgsp.bc.operator.OperatorCreationException;
import com.koalii.kgsp.bc.operator.bc.BcContentVerifierProviderBuilder;
import java.io.IOException;

public class BcDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcDSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        ExtendedDigest dig = this.digestProvider.get(digAlg);
        return new DSADigestSigner(new DSASigner(), dig);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

