/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.operator.bc;

import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.Signer;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.operator.ContentVerifier;
import com.koalii.kgsp.bc.operator.ContentVerifierProvider;
import com.koalii.kgsp.bc.operator.OperatorCreationException;
import com.koalii.kgsp.bc.operator.bc.BcDefaultDigestProvider;
import com.koalii.kgsp.bc.operator.bc.BcDigestProvider;
import com.koalii.kgsp.bc.operator.bc.BcSignerOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BcContentVerifierProviderBuilder {
    protected BcDigestProvider digestProvider = BcDefaultDigestProvider.INSTANCE;

    public ContentVerifierProvider build(final X509CertificateHolder certHolder) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            @Override
            public boolean hasAssociatedCertificate() {
                return true;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return certHolder;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    AsymmetricKeyParameter publicKey = BcContentVerifierProviderBuilder.this.extractKeyParameters(certHolder.getSubjectPublicKeyInfo());
                    BcSignerOutputStream stream = BcContentVerifierProviderBuilder.this.createSignatureStream(algorithm, publicKey);
                    return new SigVerifier(algorithm, stream);
                }
                catch (IOException e) {
                    throw new OperatorCreationException("exception on setup: " + e, e);
                }
            }
        };
    }

    public ContentVerifierProvider build(final AsymmetricKeyParameter publicKey) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            @Override
            public boolean hasAssociatedCertificate() {
                return false;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                BcSignerOutputStream stream = BcContentVerifierProviderBuilder.this.createSignatureStream(algorithm, publicKey);
                return new SigVerifier(algorithm, stream);
            }
        };
    }

    private BcSignerOutputStream createSignatureStream(AlgorithmIdentifier algorithm, AsymmetricKeyParameter publicKey) throws OperatorCreationException {
        Signer sig = this.createSigner(algorithm);
        sig.init(false, publicKey);
        return new BcSignerOutputStream(sig);
    }

    protected abstract AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo var1) throws IOException;

    protected abstract Signer createSigner(AlgorithmIdentifier var1) throws OperatorCreationException;

    private class SigVerifier
    implements ContentVerifier {
        private BcSignerOutputStream stream;
        private AlgorithmIdentifier algorithm;

        SigVerifier(AlgorithmIdentifier algorithm, BcSignerOutputStream stream) {
            this.algorithm = algorithm;
            this.stream = stream;
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithm;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.stream == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.stream;
        }

        @Override
        public boolean verify(byte[] expected) {
            return this.stream.verify(expected);
        }
    }
}

