/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.openssl.jcajce;

import com.koalii.kgsp.bc.jcajce.util.DefaultJcaJceHelper;
import com.koalii.kgsp.bc.jcajce.util.JcaJceHelper;
import com.koalii.kgsp.bc.jcajce.util.NamedJcaJceHelper;
import com.koalii.kgsp.bc.jcajce.util.ProviderJcaJceHelper;
import com.koalii.kgsp.bc.openssl.PEMDecryptor;
import com.koalii.kgsp.bc.openssl.PEMDecryptorProvider;
import com.koalii.kgsp.bc.openssl.PEMException;
import com.koalii.kgsp.bc.openssl.PasswordException;
import com.koalii.kgsp.bc.openssl.jcajce.PEMUtilities;
import java.security.Provider;

public class JcePEMDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePEMDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMDecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public PEMDecryptorProvider build(final char[] password) {
        return new PEMDecryptorProvider(){

            @Override
            public PEMDecryptor get(final String dekAlgName) {
                return new PEMDecryptor(){

                    @Override
                    public byte[] decrypt(byte[] keyBytes, byte[] iv) throws PEMException {
                        if (password == null) {
                            throw new PasswordException("Password is null, but a password is required");
                        }
                        return PEMUtilities.crypt(false, JcePEMDecryptorProviderBuilder.this.helper, keyBytes, password, dekAlgName, iv);
                    }
                };
            }
        };
    }
}

