/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.openssl;

import com.koalii.kgsp.bc.openssl.PEMDecryptor;
import com.koalii.kgsp.bc.openssl.PEMDecryptorProvider;
import com.koalii.kgsp.bc.openssl.PEMException;
import com.koalii.kgsp.bc.openssl.PEMKeyPair;
import com.koalii.kgsp.bc.openssl.PEMKeyPairParser;
import com.koalii.kgsp.bc.operator.OperatorCreationException;
import java.io.IOException;

public class PEMEncryptedKeyPair {
    private final String dekAlgName;
    private final byte[] iv;
    private final byte[] keyBytes;
    private final PEMKeyPairParser parser;

    PEMEncryptedKeyPair(String dekAlgName, byte[] iv, byte[] keyBytes, PEMKeyPairParser parser) {
        this.dekAlgName = dekAlgName;
        this.iv = iv;
        this.keyBytes = keyBytes;
        this.parser = parser;
    }

    public PEMKeyPair decryptKeyPair(PEMDecryptorProvider keyDecryptorProvider) throws IOException {
        try {
            PEMDecryptor keyDecryptor = keyDecryptorProvider.get(this.dekAlgName);
            return this.parser.parse(keyDecryptor.decrypt(this.keyBytes, this.iv));
        }
        catch (IOException e) {
            throw e;
        }
        catch (OperatorCreationException e) {
            throw new PEMException("cannot create extraction operator: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new PEMException("exception processing key pair: " + e.getMessage(), e);
        }
    }
}

