/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.jcajce.spec;

import com.koalii.kgsp.bc.asn1.edec.EdECObjectIdentifiers;
import java.security.spec.AlgorithmParameterSpec;

public class XDHParameterSpec
implements AlgorithmParameterSpec {
    public static final String X25519 = "X25519";
    public static final String X448 = "X448";
    private final String curveName;

    public XDHParameterSpec(String curveName) {
        if (curveName.equalsIgnoreCase(X25519)) {
            this.curveName = X25519;
        } else if (curveName.equalsIgnoreCase(X448)) {
            this.curveName = X448;
        } else if (curveName.equals(EdECObjectIdentifiers.id_X25519.getId())) {
            this.curveName = X25519;
        } else if (curveName.equals(EdECObjectIdentifiers.id_X448.getId())) {
            this.curveName = X448;
        } else {
            throw new IllegalArgumentException("unrecognized curve name: " + curveName);
        }
    }

    public String getCurveName() {
        return this.curveName;
    }
}

