/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.crypto.params;

import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.util.Arrays;
import com.koalii.kgsp.bc.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class Ed448PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 57;
    private final byte[] data = new byte[57];

    public Ed448PublicKeyParameters(byte[] buf, int off) {
        super(false);
        System.arraycopy(buf, off, this.data, 0, 57);
    }

    public Ed448PublicKeyParameters(InputStream input) throws IOException {
        super(false);
        if (57 != Streams.readFully(input, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed448 public key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.data, 0, buf, off, 57);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }
}

