/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.crypto.generators;

import com.koalii.kgsp.bc.crypto.AsymmetricCipherKeyPair;
import com.koalii.kgsp.bc.crypto.AsymmetricCipherKeyPairGenerator;
import com.koalii.kgsp.bc.crypto.KeyGenerationParameters;
import com.koalii.kgsp.bc.crypto.generators.DHKeyGeneratorHelper;
import com.koalii.kgsp.bc.crypto.params.DHKeyGenerationParameters;
import com.koalii.kgsp.bc.crypto.params.DHParameters;
import com.koalii.kgsp.bc.crypto.params.DHPrivateKeyParameters;
import com.koalii.kgsp.bc.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

