/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.crypto.agreement;

import com.koalii.kgsp.bc.crypto.CipherParameters;
import com.koalii.kgsp.bc.crypto.RawAgreement;
import com.koalii.kgsp.bc.crypto.params.XDHUPrivateParameters;
import com.koalii.kgsp.bc.crypto.params.XDHUPublicParameters;

public class XDHUnifiedAgreement
implements RawAgreement {
    private final RawAgreement xAgreement;
    private XDHUPrivateParameters privParams;

    public XDHUnifiedAgreement(RawAgreement xAgreement) {
        this.xAgreement = xAgreement;
    }

    @Override
    public void init(CipherParameters key) {
        this.privParams = (XDHUPrivateParameters)key;
    }

    @Override
    public int getAgreementSize() {
        return this.xAgreement.getAgreementSize() * 2;
    }

    @Override
    public void calculateAgreement(CipherParameters publicKey, byte[] buf, int off) {
        XDHUPublicParameters pubParams = (XDHUPublicParameters)publicKey;
        this.xAgreement.init(this.privParams.getEphemeralPrivateKey());
        this.xAgreement.calculateAgreement(pubParams.getEphemeralPublicKey(), buf, off);
        this.xAgreement.init(this.privParams.getStaticPrivateKey());
        this.xAgreement.calculateAgreement(pubParams.getStaticPublicKey(), buf, off + this.xAgreement.getAgreementSize());
    }
}

