/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.cms;

import com.koalii.kgsp.bc.asn1.DEROctetString;
import com.koalii.kgsp.bc.asn1.cms.KEKIdentifier;
import com.koalii.kgsp.bc.asn1.cms.KEKRecipientInfo;
import com.koalii.kgsp.bc.asn1.cms.RecipientInfo;
import com.koalii.kgsp.bc.cms.CMSException;
import com.koalii.kgsp.bc.cms.RecipientInfoGenerator;
import com.koalii.kgsp.bc.operator.GenericKey;
import com.koalii.kgsp.bc.operator.OperatorException;
import com.koalii.kgsp.bc.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kekIdentifier, SymmetricKeyWrapper wrapper) {
        this.kekIdentifier = kekIdentifier;
        this.wrapper = wrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        try {
            DEROctetString encryptedKey = new DEROctetString(this.wrapper.generateWrappedKey(contentEncryptionKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), encryptedKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
    }
}

