/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.asn1.x9;

import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.anssi.ANSSINamedCurves;
import com.koalii.kgsp.bc.asn1.cryptopro.ECGOST3410NamedCurves;
import com.koalii.kgsp.bc.asn1.gm.GMNamedCurves;
import com.koalii.kgsp.bc.asn1.nist.NISTNamedCurves;
import com.koalii.kgsp.bc.asn1.sec.SECNamedCurves;
import com.koalii.kgsp.bc.asn1.teletrust.TeleTrusTNamedCurves;
import com.koalii.kgsp.bc.asn1.x9.X962NamedCurves;
import com.koalii.kgsp.bc.asn1.x9.X9ECParameters;
import com.koalii.kgsp.bc.crypto.ec.CustomNamedCurves;
import com.koalii.kgsp.bc.crypto.params.ECDomainParameters;
import java.util.Enumeration;
import java.util.Vector;

public class ECNamedCurveTable {
    public static X9ECParameters getByName(String name) {
        X9ECParameters ecP = X962NamedCurves.getByName(name);
        if (ecP == null) {
            ecP = SECNamedCurves.getByName(name);
        }
        if (ecP == null) {
            ecP = NISTNamedCurves.getByName(name);
        }
        if (ecP == null) {
            ecP = TeleTrusTNamedCurves.getByName(name);
        }
        if (ecP == null) {
            ecP = ANSSINamedCurves.getByName(name);
        }
        if (ecP == null) {
            ecP = ECNamedCurveTable.fromDomainParameters(ECGOST3410NamedCurves.getByName(name));
        }
        if (ecP == null) {
            ecP = GMNamedCurves.getByName(name);
        }
        return ecP;
    }

    public static ASN1ObjectIdentifier getOID(String name) {
        ASN1ObjectIdentifier oid = X962NamedCurves.getOID(name);
        if (oid == null) {
            oid = SECNamedCurves.getOID(name);
        }
        if (oid == null) {
            oid = NISTNamedCurves.getOID(name);
        }
        if (oid == null) {
            oid = TeleTrusTNamedCurves.getOID(name);
        }
        if (oid == null) {
            oid = ANSSINamedCurves.getOID(name);
        }
        if (oid == null) {
            oid = ECGOST3410NamedCurves.getOID(name);
        }
        if (oid == null) {
            oid = GMNamedCurves.getOID(name);
        }
        return oid;
    }

    public static String getName(ASN1ObjectIdentifier oid) {
        String name = X962NamedCurves.getName(oid);
        if (name == null) {
            name = SECNamedCurves.getName(oid);
        }
        if (name == null) {
            name = NISTNamedCurves.getName(oid);
        }
        if (name == null) {
            name = TeleTrusTNamedCurves.getName(oid);
        }
        if (name == null) {
            name = ANSSINamedCurves.getName(oid);
        }
        if (name == null) {
            name = ECGOST3410NamedCurves.getName(oid);
        }
        if (name == null) {
            name = GMNamedCurves.getName(oid);
        }
        if (name == null) {
            name = CustomNamedCurves.getName(oid);
        }
        return name;
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier oid) {
        X9ECParameters ecP = X962NamedCurves.getByOID(oid);
        if (ecP == null) {
            ecP = SECNamedCurves.getByOID(oid);
        }
        if (ecP == null) {
            ecP = TeleTrusTNamedCurves.getByOID(oid);
        }
        if (ecP == null) {
            ecP = ANSSINamedCurves.getByOID(oid);
        }
        if (ecP == null) {
            ecP = ECNamedCurveTable.fromDomainParameters(ECGOST3410NamedCurves.getByOID(oid));
        }
        if (ecP == null) {
            ecP = GMNamedCurves.getByOID(oid);
        }
        return ecP;
    }

    public static Enumeration getNames() {
        Vector v = new Vector();
        ECNamedCurveTable.addEnumeration(v, X962NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, SECNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, NISTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, TeleTrusTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, ANSSINamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, ECGOST3410NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, GMNamedCurves.getNames());
        return v.elements();
    }

    private static void addEnumeration(Vector v, Enumeration e) {
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
    }

    private static X9ECParameters fromDomainParameters(ECDomainParameters dp) {
        return dp == null ? null : new X9ECParameters(dp.getCurve(), dp.getG(), dp.getN(), dp.getH(), dp.getSeed());
    }
}

