/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.asn1.cms;

import com.koalii.kgsp.bc.asn1.ASN1Encodable;
import com.koalii.kgsp.bc.asn1.ASN1EncodableVector;
import com.koalii.kgsp.bc.asn1.ASN1Integer;
import com.koalii.kgsp.bc.asn1.ASN1Object;
import com.koalii.kgsp.bc.asn1.ASN1Primitive;
import com.koalii.kgsp.bc.asn1.ASN1Sequence;
import com.koalii.kgsp.bc.asn1.ASN1Set;
import com.koalii.kgsp.bc.asn1.ASN1TaggedObject;
import com.koalii.kgsp.bc.asn1.BERSequence;
import com.koalii.kgsp.bc.asn1.DERInteger;
import com.koalii.kgsp.bc.asn1.DERTaggedObject;
import com.koalii.kgsp.bc.asn1.cms.EncryptedContentInfo;
import com.koalii.kgsp.bc.asn1.cms.OriginatorInfo;
import com.koalii.kgsp.bc.asn1.cms.RecipientInfo;
import java.util.Enumeration;

public class SignedAndEnvelopedData
extends ASN1Object {
    private ASN1Integer version;
    private OriginatorInfo originatorInfo;
    private ASN1Set digestAlgorithms;
    private ASN1Set recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;
    private ASN1Set unprotectedAttrs;

    public SignedAndEnvelopedData(OriginatorInfo originatorInfo, ASN1Set recipientInfos, EncryptedContentInfo encryptedContentInfo, ASN1Set unprotectedAttrs) {
        if (originatorInfo != null || unprotectedAttrs != null) {
            this.version = new DERInteger(2L);
        } else {
            this.version = new DERInteger(0L);
            Enumeration e = recipientInfos.getObjects();
            while (e.hasMoreElements()) {
                RecipientInfo ri = RecipientInfo.getInstance(e.nextElement());
                if (ri.getVersion().equals(this.version)) continue;
                this.version = new DERInteger(2L);
                break;
            }
        }
        this.originatorInfo = originatorInfo;
        this.recipientInfos = recipientInfos;
        this.encryptedContentInfo = encryptedContentInfo;
        this.unprotectedAttrs = unprotectedAttrs;
    }

    public SignedAndEnvelopedData(ASN1Sequence seq) {
        int index = 0;
        this.version = (ASN1Integer)seq.getObjectAt(index++);
        ASN1Encodable tmp = seq.getObjectAt(index++);
        if (tmp instanceof ASN1TaggedObject) {
            this.originatorInfo = OriginatorInfo.getInstance((ASN1TaggedObject)tmp, false);
            tmp = seq.getObjectAt(index++);
        }
        this.recipientInfos = ASN1Set.getInstance(tmp);
        this.digestAlgorithms = ASN1Set.getInstance(seq.getObjectAt(index++));
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(seq.getObjectAt(index));
    }

    public static SignedAndEnvelopedData getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SignedAndEnvelopedData.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static SignedAndEnvelopedData getInstance(Object obj) {
        if (obj instanceof SignedAndEnvelopedData) {
            return (SignedAndEnvelopedData)obj;
        }
        if (obj != null) {
            return new SignedAndEnvelopedData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public ASN1Set getUnprotectedAttrs() {
        return this.unprotectedAttrs;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        if (this.originatorInfo != null) {
            v.add(new DERTaggedObject(false, 0, this.originatorInfo));
        }
        v.add(this.recipientInfos);
        v.add(this.encryptedContentInfo);
        if (this.unprotectedAttrs != null) {
            v.add(new DERTaggedObject(false, 1, this.unprotectedAttrs));
        }
        return new BERSequence(v);
    }

    public static int calculateVersion(OriginatorInfo originatorInfo, ASN1Set recipientInfos, ASN1Set unprotectedAttrs) {
        int version;
        if (originatorInfo != null || unprotectedAttrs != null) {
            version = 2;
        } else {
            version = 0;
            Enumeration e = recipientInfos.getObjects();
            while (e.hasMoreElements()) {
                RecipientInfo ri = RecipientInfo.getInstance(e.nextElement());
                if (ri.getVersion().getValue().intValue() == version) continue;
                version = 2;
                break;
            }
        }
        return version;
    }
}

