/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.extensions.manager.standalone.ExtensionsStandaloneManagerFactory;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.manager.factory.standalone.StandaloneContextAware;
import ro.isdc.wro.maven.plugin.support.ExtraConfigFileAware;
import ro.isdc.wro.maven.plugin.support.ResourceChangeHandler;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.util.concurrent.TaskExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWro4jMojo
extends AbstractMojo {
    private File wroFile;
    private boolean skip;
    private String contextFolder;
    private boolean minimize;
    private String ignoreMissingResources;
    private String targetGroups;
    private MavenProject mavenProject;
    private String wroManagerFactory;
    private WroManagerFactory managerFactory;
    private File extraConfigFile;
    private BuildContext buildContext;
    private File buildDirectory;
    private boolean parallelProcessing;
    private boolean incrementalBuildEnabled;
    private TaskExecutor<Void> taskExecutor;
    private ResourceChangeHandler resourceChangeHandler;

    public final void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
        } else {
            this.validate();
            if (this.buildDirectory == null) {
                this.buildDirectory = new File(this.mavenProject.getModel().getBuild().getDirectory());
            }
            this.getLog().info((CharSequence)this.contextFolder);
            this.getLog().info((CharSequence)"Executing the mojo: ");
            this.getLog().info((CharSequence)("Wro4j Model path: " + this.wroFile.getPath()));
            this.getLog().info((CharSequence)("targetGroups: " + this.getTargetGroups()));
            this.getLog().info((CharSequence)("minimize: " + this.isMinimize()));
            this.getLog().info((CharSequence)("ignoreMissingResources: " + this.isIgnoreMissingResources()));
            this.getLog().info((CharSequence)("parallelProcessing: " + this.isParallelProcessing()));
            this.getLog().info((CharSequence)("buildDirectory: " + this.buildDirectory));
            this.getLog().debug((CharSequence)("wroManagerFactory: " + this.wroManagerFactory));
            this.getLog().debug((CharSequence)("incrementalBuildEnabled: " + this.incrementalBuildEnabled));
            this.getLog().debug((CharSequence)("extraConfig: " + this.extraConfigFile));
            this.extendPluginClasspath();
            Context.set((Context)Context.standaloneContext());
            try {
                this.onBeforeExecute();
                this.doExecute();
            }
            catch (Exception e) {
                String message = "Exception occured while processing: " + e.toString() + ", class: " + e.getClass().getName() + ",caused by: " + (e.getCause() != null ? e.getCause().getClass().getName() : "");
                this.getLog().error((CharSequence)message, (Throwable)e);
                if (e instanceof WroRuntimeException) {
                    Resource resource = ((WroRuntimeException)e).getResource();
                    this.forgetResource(resource);
                }
                throw new MojoExecutionException(message, e);
            }
            finally {
                try {
                    this.onAfterExecute();
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Exception in onAfterExecute", e);
                }
            }
        }
    }

    private void forgetResource(Resource resource) {
        if (this.resourceChangeHandler != null) {
            this.resourceChangeHandler.forget(resource);
        }
    }

    private StandaloneContext createStandaloneContext() {
        StandaloneContext runContext = new StandaloneContext();
        runContext.setContextFoldersAsCSV(this.getContextFoldersAsCSV());
        runContext.setMinimize(this.isMinimize());
        runContext.setWroFile(this.getWroFile());
        runContext.setIgnoreMissingResourcesAsString(this.isIgnoreMissingResources());
        return runContext;
    }

    protected abstract void doExecute() throws Exception;

    protected WroManagerFactory getManagerFactory() {
        if (this.managerFactory == null) {
            WroManagerFactory localManagerFactory = null;
            try {
                localManagerFactory = this.newWroManagerFactory();
            }
            catch (MojoExecutionException e) {
                throw WroRuntimeException.wrap((Exception)((Object)e));
            }
            if (localManagerFactory instanceof StandaloneContextAware) {
                ((StandaloneContextAware)localManagerFactory).initialize(this.createStandaloneContext());
            }
            this.managerFactory = this.decorateManagerFactory(localManagerFactory);
        }
        return this.managerFactory;
    }

    protected WroManagerFactory decorateManagerFactory(WroManagerFactory managerFactory) {
        return managerFactory;
    }

    protected WroManagerFactory newWroManagerFactory() throws MojoExecutionException {
        Object factory = null;
        factory = this.wroManagerFactory != null ? this.createCustomManagerFactory() : new ExtensionsStandaloneManagerFactory();
        this.getLog().info((CharSequence)("wroManagerFactory class: " + factory.getClass().getName()));
        if (factory instanceof ExtraConfigFileAware) {
            if (this.extraConfigFile == null) {
                throw new MojoExecutionException("The " + factory.getClass() + " requires a valid extraConfigFile!");
            }
            this.getLog().debug((CharSequence)("Using extraConfigFile: " + this.extraConfigFile.getAbsolutePath()));
            ((ExtraConfigFileAware)factory).setExtraConfigFile(this.extraConfigFile);
        }
        return factory;
    }

    private WroManagerFactory createCustomManagerFactory() throws MojoExecutionException {
        WroManagerFactory managerFactory;
        try {
            Class<?> wroManagerFactoryClass = Thread.currentThread().getContextClassLoader().loadClass(this.wroManagerFactory.trim());
            managerFactory = (WroManagerFactory)wroManagerFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Invalid wroManagerFactoryClass, called: " + this.wroManagerFactory, e);
        }
        return managerFactory;
    }

    protected final List<String> getTargetGroupsAsList() throws Exception {
        List<String> result = null;
        result = this.isIncrementalCheckRequired() ? this.getIncrementalGroupNames() : (this.getTargetGroups() == null ? this.getAllModelGroupNames() : Arrays.asList(this.getTargetGroups().split(",")));
        this.persistResourceFingerprints(result);
        if (result.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to process (nothing configured or nothing changed since last build).");
        } else {
            this.getLog().info((CharSequence)("The following groups will be processed: " + result));
        }
        return result;
    }

    private void persistResourceFingerprints(List<String> groupNames) {
        WroModelInspector modelInspector = new WroModelInspector(this.getModel());
        for (String groupName : groupNames) {
            Group group = modelInspector.getGroupByName(groupName);
            if (group == null) continue;
            for (Resource resource : group.getResources()) {
                this.getResourceChangeHandler().remember(resource);
            }
        }
    }

    private List<String> getIncrementalGroupNames() throws Exception {
        ArrayList<String> changedGroupNames = new ArrayList<String>();
        block0: for (Group group : this.getModel().getGroups()) {
            if (!this.isTargetGroup(group)) continue;
            for (Resource resource : group.getResources()) {
                this.getLog().debug((CharSequence)("checking delta for resource: " + resource));
                if (!this.getResourceChangeHandler().isResourceChanged(resource)) continue;
                this.getLog().debug((CharSequence)("detected change for resource: " + resource + " and group: " + group.getName()));
                changedGroupNames.add(group.getName());
                continue block0;
            }
        }
        return changedGroupNames;
    }

    private boolean isTargetGroup(Group group) {
        Validate.notNull((Object)group);
        String targetGroups = this.getTargetGroups();
        return targetGroups == null || targetGroups.contains(group.getName());
    }

    protected void validate() throws MojoExecutionException {
        if (this.wroFile == null) {
            throw new MojoExecutionException("contextFolder was not set!");
        }
        if (this.contextFolder == null) {
            throw new MojoExecutionException("no contextFolder was set!");
        }
    }

    protected final void extendPluginClasspath() throws MojoExecutionException {
        ArrayList<String> classpathElements = new ArrayList<String>();
        try {
            classpathElements.addAll(this.mavenProject.getRuntimeClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not get compile classpath elements", (Exception)((Object)e));
        }
        ClassLoader classLoader = this.createClassLoader(classpathElements);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private ClassLoader createClassLoader(List<String> classpathElements) {
        this.getLog().debug((CharSequence)"Classpath elements:");
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String element : classpathElements) {
                File elementFile = new File(element);
                this.getLog().debug((CharSequence)("Adding element to plugin classpath: " + elementFile.getPath()));
                urls.add(elementFile.toURI().toURL());
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error retreiving URL for artifact", (Throwable)e);
            throw new RuntimeException(e);
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    protected final TaskExecutor<Void> getTaskExecutor() {
        if (this.taskExecutor == null) {
            this.taskExecutor = new TaskExecutor<Void>(){

                protected void onException(Exception e) {
                    throw WroRuntimeException.wrap((Exception)e);
                }
            };
        }
        return this.taskExecutor;
    }

    protected boolean isIncrementalCheckRequired() {
        return this.isIncrementalBuild();
    }

    protected void onBeforeExecute() {
    }

    protected void onAfterExecute() {
        this.resourceChangeHandler.persist();
    }

    protected final boolean isIncrementalBuild() {
        return this.getResourceChangeHandler().isIncrementalBuild();
    }

    private List<String> getAllModelGroupNames() {
        return new WroModelInspector(this.getModel()).getGroupNames();
    }

    private WroModel getModel() {
        return (WroModel)this.getWroManager().getModelFactory().create();
    }

    private WroManager getWroManager() {
        try {
            return (WroManager)this.getManagerFactory().create();
        }
        catch (Exception e) {
            throw WroRuntimeException.wrap((Exception)e);
        }
    }

    private ResourceChangeHandler getResourceChangeHandler() {
        if (this.resourceChangeHandler == null) {
            this.resourceChangeHandler = ResourceChangeHandler.create(this.getManagerFactory(), this.getLog()).setBuildContext(this.buildContext).setBuildDirectory(this.buildDirectory).setIncrementalBuildEnabled(this.incrementalBuildEnabled);
        }
        return this.resourceChangeHandler;
    }

    @VisibleForTesting
    void setTaskExecutor(TaskExecutor<Void> taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    String getContextFoldersAsCSV() {
        return this.contextFolder;
    }

    void setContextFolder(String contextFolder) {
        this.contextFolder = contextFolder;
    }

    void setWroFile(File wroFile) {
        this.wroFile = wroFile;
    }

    File getWroFile() {
        return this.wroFile;
    }

    void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    void setIgnoreMissingResources(String ignoreMissingResourcesAsString) {
        this.ignoreMissingResources = ignoreMissingResourcesAsString;
    }

    void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.setIgnoreMissingResources(Boolean.toString(ignoreMissingResources));
    }

    protected final boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    final void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    void setIncrementalBuildEnabled(boolean incrementalBuildEnabled) {
        this.incrementalBuildEnabled = incrementalBuildEnabled;
    }

    boolean isMinimize() {
        return this.minimize;
    }

    String isIgnoreMissingResources() {
        return this.ignoreMissingResources;
    }

    void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    String getTargetGroups() {
        return this.targetGroups;
    }

    void setTargetGroups(String targetGroups) {
        this.targetGroups = targetGroups;
    }

    void setWroManagerFactory(String wroManagerFactory) {
        this.wroManagerFactory = wroManagerFactory;
    }

    void setExtraConfigFile(File extraConfigFile) {
        this.extraConfigFile = extraConfigFile;
    }

    void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    void setSkip(boolean skip) {
        this.skip = skip;
    }

    void clean() {
        try {
            this.getResourceChangeHandler().destroy();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to destroy resourceChangeHandler", (Throwable)e);
        }
    }
}

