/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.DelegatingServletOutputStream;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.manager.factory.WroManagerFactoryDecorator;
import ro.isdc.wro.maven.plugin.AbstractWro4jMojo;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.SimpleProcessorsFactory;
import ro.isdc.wro.util.io.NullOutputStream;

public abstract class AbstractSingleProcessorMojo
extends AbstractWro4jMojo {
    private String options;
    private boolean failNever;

    public final void doExecute() throws Exception {
        this.getLog().info((CharSequence)("options: " + this.options));
        ArrayList<Callable> callables = new ArrayList<Callable>();
        List<String> groupsAsList = this.getTargetGroupsAsList();
        for (final String group : groupsAsList) {
            for (final ResourceType resourceType : ResourceType.values()) {
                if (this.isParallelProcessing()) {
                    callables.add(Context.decorate((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            AbstractSingleProcessorMojo.this.processGroup(group, resourceType);
                            return null;
                        }
                    }));
                    continue;
                }
                this.processGroup(group, resourceType);
            }
        }
        if (this.isParallelProcessing()) {
            this.getTaskExecutor().submit(callables);
        }
    }

    private void processGroup(String groupName, ResourceType resourceType) throws Exception {
        if (this.wantProcessGroup(groupName, resourceType)) {
            String group = groupName + "." + resourceType.name().toLowerCase();
            this.getLog().info((CharSequence)("processing group: " + group));
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURI()).thenReturn((Object)group);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.getOutputStream()).thenReturn((Object)new DelegatingServletOutputStream((OutputStream)new NullOutputStream()));
            WroConfiguration config = Context.get().getConfig();
            Context.set((Context)Context.webContext((HttpServletRequest)request, (HttpServletResponse)response, (FilterConfig)((FilterConfig)Mockito.mock(FilterConfig.class))), (WroConfiguration)config);
            ((WroManager)this.getManagerFactory().create()).process();
            this.getLog().debug((CharSequence)("Processing group: " + group + " [OK]"));
        }
    }

    protected boolean wantProcessGroup(String groupName, ResourceType resourceType) {
        return true;
    }

    protected WroManagerFactory decorateManagerFactory(WroManagerFactory managerFactory) {
        return new WroManagerFactoryDecorator(managerFactory){

            protected void onBeforeBuild(WroManager.Builder builder) {
                builder.setProcessorsFactory(AbstractSingleProcessorMojo.this.createSingleProcessorsFactory());
            }
        };
    }

    private ProcessorsFactory createSingleProcessorsFactory() {
        SimpleProcessorsFactory factory = new SimpleProcessorsFactory();
        ResourcePreProcessor processor = this.createResourceProcessor();
        factory.addPreProcessor(processor);
        return factory;
    }

    protected abstract ResourcePreProcessor createResourceProcessor();

    protected String getOptions() {
        return this.options;
    }

    void setOptions(String options) {
        this.options = options;
    }

    public void setFailNever(boolean failNever) {
        this.failNever = failNever;
    }

    public boolean isFailNever() {
        return this.failNever;
    }
}

