/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.jgit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.project13.jgit.DescribeResult;
import pl.project13.jgit.JGitCommon;
import pl.project13.jgit.dummy.DatedRevTag;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.log.StdOutLoggerBridge;
import pl.project13.maven.git.util.Pair;

public class DescribeCommand
extends GitCommand<DescribeResult> {
    private LoggerBridge loggerBridge;
    private JGitCommon jGitCommon;
    private Optional<String> matchOption = Optional.absent();
    private int abbrev = 7;
    private boolean tagsFlag = false;
    private boolean alwaysFlag = true;
    private boolean forceLongFormat = false;
    private Optional<String> dirtyOption = Optional.absent();

    @NotNull
    public static DescribeCommand on(Repository repo) {
        return new DescribeCommand(repo);
    }

    private DescribeCommand(Repository repo) {
        this(repo, true);
    }

    private DescribeCommand(Repository repo, boolean verbose) {
        super(repo);
        this.initDefaultLoggerBridge(verbose);
        this.setVerbose(verbose);
        this.jGitCommon = new JGitCommon();
    }

    private void initDefaultLoggerBridge(boolean verbose) {
        this.loggerBridge = new StdOutLoggerBridge(verbose);
    }

    @NotNull
    public DescribeCommand setVerbose(boolean verbose) {
        this.loggerBridge.setVerbose(verbose);
        return this;
    }

    @NotNull
    public DescribeCommand withLoggerBridge(LoggerBridge bridge) {
        this.loggerBridge = bridge;
        return this;
    }

    @NotNull
    public DescribeCommand always(boolean always) {
        this.alwaysFlag = always;
        this.log("--always =", always);
        return this;
    }

    @NotNull
    public DescribeCommand forceLongFormat(@Nullable Boolean forceLongFormat) {
        if (forceLongFormat != null && forceLongFormat.booleanValue()) {
            this.forceLongFormat = true;
            this.log("--long =", true);
        }
        return this;
    }

    @NotNull
    public DescribeCommand abbrev(@Nullable Integer n) {
        if (n != null) {
            Preconditions.checkArgument((n < 41 ? 1 : 0) != 0, (Object)String.format("N (commit abbres length) must be < 41. (Was:[%s])", n));
            Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)String.format("N (commit abbrev length) must be positive! (Was [%s])", n));
            this.log("--abbrev =", n);
            this.abbrev = n;
        }
        return this;
    }

    @NotNull
    public DescribeCommand tags(@Nullable Boolean includeLightweightTagsInSearch) {
        if (includeLightweightTagsInSearch != null && includeLightweightTagsInSearch.booleanValue()) {
            this.tagsFlag = includeLightweightTagsInSearch;
            this.log("--tags =", includeLightweightTagsInSearch);
        }
        return this;
    }

    public DescribeCommand tags() {
        return this.tags(true);
    }

    @NotNull
    public DescribeCommand apply(@Nullable GitDescribeConfig config) {
        if (config != null) {
            this.always(config.isAlways());
            this.dirty(config.getDirty());
            this.abbrev(config.getAbbrev());
            this.forceLongFormat(config.getForceLongFormat());
            this.tags(config.getTags());
            this.match(config.getMatch());
        }
        return this;
    }

    @NotNull
    public DescribeCommand dirty(@Nullable String dirtyMarker) {
        Optional option = Optional.fromNullable((Object)dirtyMarker);
        this.log("--dirty =", option.or((Object)""));
        this.dirtyOption = option;
        return this;
    }

    @NotNull
    public DescribeCommand match(@Nullable String pattern) {
        if (!"*".equals(pattern)) {
            this.matchOption = Optional.fromNullable((Object)pattern);
            this.log("--match =", this.matchOption.or((Object)""));
        }
        return this;
    }

    public DescribeResult call() throws GitAPIException {
        ObjectReader objectReader = this.repo.newObjectReader();
        Map<ObjectId, List<String>> tagObjectIdToName = this.findTagObjectIds(this.repo, this.tagsFlag);
        RevCommit headCommit = this.findHeadObjectId(this.repo);
        ObjectId headCommitId = headCommit.getId();
        boolean dirty = this.findDirtyState(this.repo);
        if (DescribeCommand.hasTags((ObjectId)headCommit, tagObjectIdToName) && !this.forceLongFormat) {
            String tagName = tagObjectIdToName.get(headCommit).iterator().next();
            this.log("The commit we're on is a Tag ([", tagName, "]) and forceLongFormat == false, returning.");
            return new DescribeResult(tagName, dirty, this.dirtyOption);
        }
        List<RevCommit> commits = this.jGitCommon.findCommitsUntilSomeTag(this.repo, headCommit, tagObjectIdToName);
        if (DescribeCommand.foundZeroTags(tagObjectIdToName) || commits.isEmpty()) {
            return new DescribeResult(objectReader, headCommitId, dirty, this.dirtyOption).withCommitIdAbbrev(this.abbrev);
        }
        int distance = this.jGitCommon.distanceBetween(this.repo, headCommit, commits.get(0));
        String tagName = tagObjectIdToName.get(commits.get(0)).iterator().next();
        Pair<Integer, String> howFarFromWhichTag = Pair.of(distance, tagName);
        return this.createDescribeResult(objectReader, headCommitId, dirty, howFarFromWhichTag);
    }

    private DescribeResult createDescribeResult(ObjectReader objectReader, ObjectId headCommitId, boolean dirty, @Nullable Pair<Integer, String> howFarFromWhichTag) {
        if (howFarFromWhichTag == null) {
            return new DescribeResult(objectReader, headCommitId, dirty, this.dirtyOption).withCommitIdAbbrev(this.abbrev);
        }
        if ((Integer)howFarFromWhichTag.first > 0 || this.forceLongFormat) {
            return new DescribeResult(objectReader, (String)howFarFromWhichTag.second, (Integer)howFarFromWhichTag.first, headCommitId, dirty, this.dirtyOption, this.forceLongFormat).withCommitIdAbbrev(this.abbrev);
        }
        if ((Integer)howFarFromWhichTag.first == 0) {
            return new DescribeResult((String)howFarFromWhichTag.second).withCommitIdAbbrev(this.abbrev);
        }
        if (this.alwaysFlag) {
            return new DescribeResult(objectReader, headCommitId).withCommitIdAbbrev(this.abbrev);
        }
        return DescribeResult.EMPTY;
    }

    private static boolean foundZeroTags(@NotNull Map<ObjectId, List<String>> tags) {
        return tags.isEmpty();
    }

    @VisibleForTesting
    boolean findDirtyState(Repository repo) throws GitAPIException {
        Git git = Git.wrap((Repository)repo);
        Status status = git.status().call();
        boolean isDirty = !status.getAdded().isEmpty() || !status.getChanged().isEmpty() || !status.getRemoved().isEmpty() || !status.getMissing().isEmpty() || !status.getModified().isEmpty() || !status.getConflicting().isEmpty();
        this.log("Repo is in dirty state [", isDirty, "]");
        return isDirty;
    }

    @VisibleForTesting
    static boolean hasTags(ObjectId headCommit, @NotNull Map<ObjectId, List<String>> tagObjectIdToName) {
        return tagObjectIdToName.containsKey(headCommit);
    }

    RevCommit findHeadObjectId(@NotNull Repository repo) throws RuntimeException {
        try {
            ObjectId headId = repo.resolve("HEAD");
            RevWalk walk = new RevWalk(repo);
            RevCommit headCommit = walk.lookupCommit((AnyObjectId)headId);
            walk.dispose();
            this.log("HEAD is [", headCommit.getName(), "] ");
            return headCommit;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to obtain HEAD commit!", ex);
        }
    }

    private Map<ObjectId, List<String>> findTagObjectIds(@NotNull Repository repo, boolean tagsFlag) {
        String matchPattern = this.createMatchPattern();
        Map<ObjectId, List<DatedRevTag>> commitIdsToTags = this.jGitCommon.getCommitIdsToTags(this.loggerBridge, repo, tagsFlag, matchPattern);
        HashMap<ObjectId, List<String>> commitIdsToTagNames = this.jGitCommon.transformRevTagsMapToDateSortedTagNames(commitIdsToTags);
        this.log("Created map: [", commitIdsToTagNames, "] ");
        return commitIdsToTagNames;
    }

    private String createMatchPattern() {
        if (!this.matchOption.isPresent()) {
            return ".*";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("^refs/tags/\\Q");
        buf.append(((String)this.matchOption.get()).replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q"));
        buf.append("\\E$");
        return buf.toString();
    }

    private void log(Object ... parts) {
        this.loggerBridge.log(parts);
    }
}

