/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.xml;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.pentaho.di.core.xml.XMLHandlerCacheEntry;

public class XMLHandlerCache {
    private static XMLHandlerCache instance;
    Map<XMLHandlerCacheEntry, Integer> cache = Collections.synchronizedMap(new WeakHashMap());
    private volatile int cacheHits = 0;

    private XMLHandlerCache() {
    }

    public static synchronized XMLHandlerCache getInstance() {
        if (instance == null) {
            instance = new XMLHandlerCache();
            return instance;
        }
        return instance;
    }

    public void storeCache(XMLHandlerCacheEntry entry, int lastChildNr) {
        this.cache.put(entry, lastChildNr);
    }

    public int getLastChildNr(XMLHandlerCacheEntry entry) {
        Integer lastChildNr = this.cache.get(entry);
        if (lastChildNr != null) {
            ++this.cacheHits;
            return lastChildNr;
        }
        return -1;
    }

    public int getCacheHits() {
        return this.cacheHits;
    }

    public void setCacheHits(int cacheHits) {
        this.cacheHits = cacheHits;
    }

    public void clear() {
        this.cache.clear();
    }
}

