/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    public static String responseToString(HttpResponse response) throws IOException {
        return HttpClientUtil.responseToString(response, Charset.forName(StandardCharsets.UTF_8.name()));
    }

    public static String responseToString(HttpResponse response, Charset charset) throws IOException {
        return HttpClientUtil.responseToString(response, charset, false);
    }

    public static String responseToString(HttpResponse response, Charset charset, boolean decode) throws IOException {
        HttpEntity entity = response.getEntity();
        String result = EntityUtils.toString((HttpEntity)entity, (Charset)charset);
        EntityUtils.consume((HttpEntity)entity);
        if (decode) {
            result = URLDecoder.decode(result, StandardCharsets.UTF_8.name());
        }
        return result;
    }

    public static InputStream responseToInputStream(HttpResponse response) throws IOException {
        return response.getEntity().getContent();
    }

    public static byte[] responseToByteArray(HttpResponse response) throws IOException {
        return EntityUtils.toByteArray((HttpEntity)response.getEntity());
    }

    public static HttpClientContext createPreemptiveBasicAuthentication(String host, int port, String user, String password, String schema) {
        HttpClientContext localContext = null;
        try {
            HttpHost target = new HttpHost(host, port, schema);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(target.getHostName(), target.getPort()), (Credentials)new UsernamePasswordCredentials(user, password));
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(target, (AuthScheme)basicAuth);
            localContext = HttpClientContext.create();
            localContext.setAuthCache((AuthCache)authCache);
        }
        catch (Exception e) {
            return null;
        }
        return localContext;
    }

    public static HttpClientContext createPreemptiveBasicAuthentication(String host, int port, String user, String password) {
        return HttpClientUtil.createPreemptiveBasicAuthentication(host, port, user, password, "http");
    }
}

