/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.IngresDatabaseMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;

public class VectorWiseDatabaseMeta
extends IngresDatabaseMeta
implements DatabaseInterface {
    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        if (Utils.isEmpty(port) || "-1".equals(port)) {
            return "jdbc:ingres://" + hostname + ":VW7/" + databaseName;
        }
        return "jdbc:ingres://" + hostname + ":" + port + "/" + databaseName;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP COLUMN " + v.getName() + Const.CR;
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval = retval + "GENERATED ALWAYS AS IDENTITY START WITH 1 INCREMENT BY 1";
                        break;
                    }
                    retval = retval + "BIGINT PRIMARY KEY NOT NULL";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    if (length == -1 || length > 4) {
                        retval = retval + "INTEGER";
                        break;
                    }
                    if (length > 2) {
                        retval = retval + "SMALLINT";
                        break;
                    }
                    retval = retval + "INTEGER1";
                    break;
                }
                retval = retval + "FLOAT8";
                break;
            }
            case 2: {
                if (length > 0) {
                    if (length > 32000) {
                        retval = retval + "VARCHAR(32000)";
                        break;
                    }
                    retval = retval + "VARCHAR(" + length + ")";
                    break;
                }
                retval = retval + "VARCHAR(9999)";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "CALL VECTORWISE( COMBINE '" + tableName + " - " + tableName + "' )";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"iijdbc.jar"};
    }

    @Override
    public boolean supportsGetBlob() {
        return false;
    }
}

