/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastDataStore
implements IDataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastDataStore.class);
    private final HazelcastInstance hazelcast;

    public HazelcastDataStore(HazelcastInstance hazelcast) {
        this.hazelcast = (HazelcastInstance)Args.notNull((Object)hazelcast, (String)"hazelcast");
    }

    public byte[] getData(String sessionId, int pageId) {
        byte[] bytes = null;
        IMap map = this.hazelcast.getMap(sessionId);
        if (map != null) {
            bytes = (byte[])map.get((Object)pageId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Got {} for session '{}' and page id '{}'", new Object[]{bytes != null ? "data" : "'null'", sessionId, pageId});
        }
        return bytes;
    }

    public void removeData(String sessionId, int pageId) {
        byte[] removed;
        IMap map = this.hazelcast.getMap(sessionId);
        if (map != null && (removed = (byte[])map.remove((Object)pageId)) != null) {
            LOGGER.debug("Deleted data for session '{}' and page with id '{}'", (Object)sessionId, (Object)pageId);
        }
    }

    public void removeData(String sessionId) {
        IMap map = this.hazelcast.getMap(sessionId);
        map.clear();
        LOGGER.debug("Deleted data for session '{}'", (Object)sessionId);
    }

    public void storeData(String sessionId, int pageId, byte[] data) {
        IMap map = this.hazelcast.getMap(sessionId);
        map.put((Object)pageId, (Object)data);
        LOGGER.debug("Inserted data for session '{}' and page id '{}'", (Object)sessionId, (Object)pageId);
    }

    public void destroy() {
        if (this.hazelcast != null) {
            this.hazelcast.shutdown();
        }
    }

    public boolean isReplicated() {
        return true;
    }

    public boolean canBeAsynchronous() {
        return true;
    }
}

