/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import org.vafer.jdeb.Compression;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.shaded.compress.compress.archivers.tar.TarArchiveEntry;
import org.vafer.jdeb.shaded.compress.compress.archivers.tar.TarArchiveOutputStream;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipEncoding;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipEncodingHelper;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorException;
import org.vafer.jdeb.utils.Utils;

class DataBuilder {
    private Console console;
    private ZipEncoding encoding;

    DataBuilder(Console console) {
        this.console = console;
        this.encoding = ZipEncodingHelper.getZipEncoding(null);
    }

    private void checkField(String name, int length) throws IOException {
        ByteBuffer b;
        if (name != null && (b = this.encoding.encode(name)).limit() > length) {
            throw new IllegalArgumentException("Field '" + name + "' too long, maximum is " + length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigInteger buildData(Collection<DataProducer> producers, File output, final StringBuilder checksums, Compression compression) throws NoSuchAlgorithmException, IOException, CompressorException {
        File dir = output.getParentFile();
        if (!(dir == null || dir.exists() && dir.isDirectory())) {
            throw new IOException("Cannot write data file at '" + output.getAbsolutePath() + "'");
        }
        final TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream(compression.toCompressedOutputStream(new FileOutputStream(output)));
        tarOutputStream.setLongFileMode(2);
        final MessageDigest digest = MessageDigest.getInstance("MD5");
        final Total dataSize = new Total();
        final ArrayList addedDirectories = new ArrayList();
        DataConsumer receiver = new DataConsumer(){

            @Override
            public void onEachDir(String dirname, String linkname, String user, int uid, String group, int gid, int mode, long size) throws IOException {
                DataBuilder.this.checkField(linkname, 100);
                DataBuilder.this.checkField(user, 32);
                DataBuilder.this.checkField(group, 32);
                dirname = DataBuilder.this.fixPath(dirname);
                this.createParentDirectories(dirname, user, uid, group, gid);
                this.createDirectory(dirname, user, uid, group, gid, mode, 0L);
                DataBuilder.this.console.debug("dir: " + dirname);
            }

            @Override
            public void onEachFile(InputStream input, TarArchiveEntry entry) throws IOException {
                DataBuilder.this.checkField(entry.getLinkName(), 100);
                DataBuilder.this.checkField(entry.getUserName(), 32);
                DataBuilder.this.checkField(entry.getGroupName(), 32);
                entry.setName(DataBuilder.this.fixPath(entry.getName()));
                this.createParentDirectories(entry.getName(), entry.getUserName(), entry.getUserId(), entry.getGroupName(), entry.getGroupId());
                tarOutputStream.putArchiveEntry(entry);
                dataSize.add(entry.getSize());
                digest.reset();
                Utils.copy(input, new DigestOutputStream(tarOutputStream, digest));
                String md5 = Utils.toHex(digest.digest());
                tarOutputStream.closeArchiveEntry();
                DataBuilder.this.console.debug("file:" + entry.getName() + " size:" + entry.getSize() + " mode:" + entry.getMode() + " linkname:" + entry.getLinkName() + " username:" + entry.getUserName() + " userid:" + entry.getUserId() + " groupname:" + entry.getGroupName() + " groupid:" + entry.getGroupId() + " modtime:" + entry.getModTime() + " md5: " + md5);
                checksums.append(md5).append("  ").append(entry.getName()).append('\n');
            }

            @Override
            public void onEachLink(TarArchiveEntry entry) throws IOException {
                DataBuilder.this.checkField(entry.getLinkName(), 100);
                DataBuilder.this.checkField(entry.getUserName(), 32);
                DataBuilder.this.checkField(entry.getGroupName(), 32);
                entry.setName(DataBuilder.this.fixPath(entry.getName()));
                this.createParentDirectories(entry.getName(), entry.getUserName(), entry.getUserId(), entry.getGroupName(), entry.getGroupId());
                tarOutputStream.putArchiveEntry(entry);
                tarOutputStream.closeArchiveEntry();
                DataBuilder.this.console.debug("link:" + entry.getName() + " mode:" + entry.getMode() + " linkname:" + entry.getLinkName() + " username:" + entry.getUserName() + " userid:" + entry.getUserId() + " groupname:" + entry.getGroupName() + " groupid:" + entry.getGroupId());
            }

            private void createDirectory(String directory, String user, int uid, String group, int gid, int mode, long size) throws IOException {
                if (!directory.endsWith("/")) {
                    directory = directory + "/";
                }
                if (!addedDirectories.contains(directory)) {
                    TarArchiveEntry entry = new TarArchiveEntry(directory, true);
                    entry.setUserName(user);
                    entry.setUserId(uid);
                    entry.setGroupName(group);
                    entry.setGroupId(gid);
                    entry.setMode(mode);
                    entry.setSize(size);
                    tarOutputStream.putArchiveEntry(entry);
                    tarOutputStream.closeArchiveEntry();
                    addedDirectories.add(directory);
                }
            }

            private void createParentDirectories(String filename, String user, int uid, String group, int gid) throws IOException {
                String dirname = DataBuilder.this.fixPath(new File(filename).getParent());
                if (dirname == null) {
                    return;
                }
                String[] pathParts = dirname.split("/");
                String parentDir = "./";
                for (int i = 1; i < pathParts.length; ++i) {
                    parentDir = parentDir + pathParts[i] + "/";
                    int mode = 16877;
                    this.createDirectory(parentDir, user, uid, group, gid, mode, 0L);
                }
            }
        };
        try {
            for (DataProducer data : producers) {
                data.produce(receiver);
            }
        }
        finally {
            tarOutputStream.close();
        }
        this.console.debug("Total size: " + dataSize);
        return dataSize.count;
    }

    private String fixPath(String path) {
        if (path == null || path.equals(".")) {
            return path;
        }
        if (path.contains("\\")) {
            path = path.replace('\\', '/');
        }
        if (path.startsWith("/")) {
            path = "." + path;
        } else if (!path.startsWith("./")) {
            path = "./" + path;
        }
        return path;
    }

    private static final class Total {
        private BigInteger count = BigInteger.valueOf(0L);

        private Total() {
        }

        public void add(long size) {
            this.count = this.count.add(BigInteger.valueOf(size));
        }

        public String toString() {
            return "" + this.count;
        }
    }
}

