/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.descriptors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

public abstract class AbstractDescriptor {
    private final Map values = new HashMap();
    private final VariableResolver resolver;
    private static String openToken = "[[";
    private static String closeToken = "]]";

    public AbstractDescriptor(VariableResolver pResolver) {
        this.resolver = pResolver;
    }

    public AbstractDescriptor(AbstractDescriptor pDescriptor) {
        this.values.putAll(pDescriptor.values);
        this.resolver = pDescriptor.resolver;
    }

    public static void setOpenToken(String pToken) {
        openToken = pToken;
    }

    public static void setCloseToken(String pToken) {
        closeToken = pToken;
    }

    protected void parse(InputStream pInput) throws IOException, ParseException {
        BufferedReader br = new BufferedReader(new InputStreamReader(pInput));
        StringBuffer buffer = new StringBuffer();
        String key = null;
        int linenr = 0;
        while (true) {
            String line;
            if ((line = br.readLine()) == null) {
                if (buffer.length() <= 0) break;
                this.set(key, buffer.toString());
                buffer = null;
                break;
            }
            ++linenr;
            if (line.length() == 0) {
                throw new ParseException("Empty line", linenr);
            }
            char first = line.charAt(0);
            if (Character.isLetter(first)) {
                int i;
                if (buffer.length() > 0) {
                    this.set(key, buffer.toString());
                    buffer = new StringBuffer();
                }
                if ((i = line.indexOf(58)) < 0) {
                    throw new ParseException("Line misses ':' delimitter", linenr);
                }
                key = line.substring(0, i);
                buffer.append(line.substring(i + 1).trim());
                continue;
            }
            buffer.append('\n').append(line.substring(1));
        }
        br.close();
    }

    public void set(String pKey, String pValue) {
        if (this.resolver != null) {
            try {
                this.values.put(pKey, Utils.replaceVariables(this.resolver, pValue, openToken, closeToken));
                return;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.values.put(pKey, pValue);
    }

    public String get(String pKey) {
        return (String)this.values.get(pKey);
    }

    public abstract String[] getMandatoryKeys();

    public boolean isValid() {
        return this.invalidKeys().size() == 0;
    }

    public Set invalidKeys() {
        HashSet<String> invalid = new HashSet<String>();
        String[] mk = this.getMandatoryKeys();
        for (int i = 0; i < mk.length; ++i) {
            if (this.get(mk[i]) != null) continue;
            invalid.add(mk[i]);
        }
        return invalid;
    }

    public String toString(String[] pKeys) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < pKeys.length; ++i) {
            String key = pKeys[i];
            String value = (String)this.values.get(key);
            if (value == null) continue;
            s.append(key).append(":");
            try {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(value));
                while ((line = reader.readLine()) != null) {
                    if (line.length() != 0 && !Character.isWhitespace(line.charAt(0))) {
                        s.append(' ');
                    }
                    s.append(line).append('\n');
                }
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return s.toString();
    }
}

