/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xstream;

import com.thoughtworks.xstream.XStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.ClassFiledUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.xstream.config.XStreamAnnotationClass;
import org.tinygroup.xstream.config.XStreamClassAlias;
import org.tinygroup.xstream.config.XStreamClassAliases;
import org.tinygroup.xstream.config.XStreamClassPropertyAlias;
import org.tinygroup.xstream.config.XStreamConfiguration;

public final class XStreamFactory {
    private static Map<String, XStream> xstreamMap = new HashMap<String, XStream>();

    private XStreamFactory() {
    }

    public static XStream getXStream() {
        return XStreamFactory.getXStream("");
    }

    public static XStream getXStream(String key) {
        XStream xstream;
        String xstreamKey = key;
        if (key == null) {
            xstreamKey = "";
        }
        if ((xstream = xstreamMap.get(xstreamKey)) == null) {
            xstream = XStreamFactory.newXStream(null);
            xstreamMap.put(xstreamKey, xstream);
        }
        return xstream;
    }

    public static XStream getXStream(String key, ClassLoader classLoader) {
        XStream xstream;
        String xstreamKey = key;
        if (key == null) {
            xstreamKey = "";
        }
        if ((xstream = xstreamMap.get(xstreamKey)) == null) {
            xstream = XStreamFactory.newXStream(classLoader);
            xstreamMap.put(xstreamKey, xstream);
        }
        return xstream;
    }

    private static XStream newXStream(ClassLoader classLoader) {
        XStream xstream = new XStream();
        if (classLoader != null) {
            xstream.setClassLoader(classLoader);
        } else {
            xstream.setClassLoader(XStreamFactory.class.getClassLoader());
        }
        xstream.autodetectAnnotations(true);
        xstream.setMode(1001);
        xstream.processAnnotations(XStreamConfiguration.class);
        return xstream;
    }

    public static void clear() {
        xstreamMap.clear();
    }

    public static void parse(XStreamConfiguration xstreamConfiguration) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        XStream xStream = XStreamFactory.getXStream(xstreamConfiguration.getPackageName());
        XStreamFactory.loadAnnotationClass(xStream, xstreamConfiguration);
        if (xstreamConfiguration.getxStreamClassAliases() != null) {
            XStreamFactory.processClassAliases(xStream, xstreamConfiguration.getxStreamClassAliases());
        }
    }

    private static void loadAnnotationClass(XStream xStream, XStreamConfiguration xstreamConfiguration) throws ClassNotFoundException {
        if (xstreamConfiguration.getxStreamAnnotationClasses() != null) {
            for (XStreamAnnotationClass annotationClass : xstreamConfiguration.getxStreamAnnotationClasses()) {
                xStream.processAnnotations(Class.forName(annotationClass.getClassName()));
            }
        }
    }

    private static void processClassAliases(XStream xStream, XStreamClassAliases classAliases) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (classAliases.getClassAliases() != null) {
            for (XStreamClassAlias classAlias : classAliases.getClassAliases()) {
                Class<?> clazz = Class.forName(classAlias.getType());
                xStream.alias(classAlias.getAliasName(), clazz);
                XStreamFactory.processClassAlias(xStream, classAlias, clazz);
            }
        }
    }

    private static void processClassAlias(XStream xStream, XStreamClassAlias classAlias, Class<?> clazz) throws InstantiationException, IllegalAccessException {
        List<XStreamClassPropertyAlias> list = classAlias.getList();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (XStreamClassPropertyAlias propertyAlias : list) {
            XStreamFactory.processClassProperty(xStream, propertyAlias, clazz);
        }
    }

    private static void processClassProperty(XStream xStream, XStreamClassPropertyAlias propertyAlias, Class<?> clazz) {
        String propertyName = propertyAlias.getPropertyName();
        Field field = ClassFiledUtil.getDeclaredFieldWithParent(clazz, (String)propertyName);
        String aliasName = propertyAlias.getAliasName();
        boolean asTttribute = propertyAlias.isAsTttribute();
        boolean implicit = propertyAlias.isImplicit();
        boolean omit = propertyAlias.isOmit();
        if (omit) {
            xStream.omitField(clazz, propertyName);
        }
        if (implicit && field != null) {
            if (field.getType().isArray()) {
                xStream.addImplicitArray(clazz, propertyName);
            } else if (ClassFiledUtil.implmentInterface(field.getType(), Collection.class)) {
                xStream.addImplicitCollection(clazz, propertyName);
            }
        }
        if (!StringUtil.isBlank((String)aliasName)) {
            if (!asTttribute) {
                xStream.aliasField(aliasName, clazz, propertyName);
            } else {
                xStream.aliasAttribute(clazz, propertyName, aliasName);
            }
        }
    }
}

