/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xstream;

import com.thoughtworks.xstream.converters.enums.EnumSingleValueConverter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class CustomEnumSingleNameConverter
extends EnumSingleValueConverter {
    private static final String CUSTOM_ENUM_NAME_METHOD = "getName";
    private static final String CUSTOM_ENUM_VALUE_OF_METHOD = "toEnum";
    private Class<? extends Enum<?>> enumType;

    public CustomEnumSingleNameConverter(Class<? extends Enum<?>> type) {
        super(type);
        this.enumType = type;
    }

    public String toString(Object obj) {
        Method method = this.getCustomEnumNameMethod();
        if (method == null) {
            return super.toString(obj);
        }
        try {
            return (String)method.invoke(obj, (Object[])null);
        }
        catch (Exception ex) {
            return super.toString(obj);
        }
    }

    public Object fromString(String str) {
        Method method = this.getCustomEnumStaticValueOfMethod();
        if (method == null) {
            return this.enhancedFromString(str);
        }
        try {
            return method.invoke(null, str);
        }
        catch (Exception ex) {
            return this.enhancedFromString(str);
        }
    }

    private Method getCustomEnumNameMethod() {
        try {
            return this.enumType.getMethod(CUSTOM_ENUM_NAME_METHOD, null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Method getCustomEnumStaticValueOfMethod() {
        try {
            Method method = this.enumType.getMethod(CUSTOM_ENUM_VALUE_OF_METHOD, String.class);
            if (Modifier.isStatic(method.getModifiers())) {
                return method;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Object enhancedFromString(String str) {
        try {
            return super.fromString(str);
        }
        catch (Exception ex) {
            for (Enum<?> item : this.enumType.getEnumConstants()) {
                if (!item.name().equalsIgnoreCase(str)) continue;
                return item;
            }
            throw new IllegalStateException("Cannot converter <" + str + "> to enum <" + this.enumType + ">");
        }
    }
}

