/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser.parser;

import org.tinygroup.parser.NodeType;
import org.tinygroup.parser.Parser;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.XmlNodeType;
import org.tinygroup.xmlparser.node.XmlNode;

public abstract class XmlParser<Source>
implements Parser<XmlNode, XmlDocument, Source> {
    private static String startPattern = null;

    static String getHeadEndPattern(NodeType nt) {
        if (nt.getHead() != null && nt.getHead().getEnd() != null) {
            return XmlParser.replaceSpecialChar(nt.getHead().getEnd());
        }
        return null;
    }

    static String getTailStartPattern(NodeType nt) {
        if (nt.getTail() != null && nt.getTail().getStart() != null) {
            return XmlParser.replaceSpecialChar(nt.getTail().getStart());
        }
        return null;
    }

    static String getTailEndPattern(NodeType nt) {
        if (nt.getTail() != null && nt.getTail().getEnd() != null) {
            return XmlParser.replaceSpecialChar(nt.getTail().getEnd());
        }
        return null;
    }

    static String getHeadStartPattern() {
        if (startPattern != null) {
            return startPattern;
        }
        StringBuffer pattern = new StringBuffer("<[/]|[/]>");
        for (XmlNodeType nt : XmlNodeType.values()) {
            String sn;
            if (nt.getHead() == null || (sn = nt.getHead().getStart()) == null) continue;
            if (pattern.length() > 0) {
                pattern.append("|");
            }
            pattern.append(XmlParser.replaceSpecialChar(sn));
        }
        startPattern = pattern.toString();
        return startPattern;
    }

    private static String replaceSpecialChar(String sn) {
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < sn.length(); ++i) {
            char c = sn.charAt(i);
            switch (c) {
                case '[': {
                    sb.append("\\[");
                    continue block7;
                }
                case ']': {
                    sb.append("\\]");
                    continue block7;
                }
                case '?': {
                    sb.append("\\?");
                    continue block7;
                }
                case '!': {
                    sb.append("\\!");
                    continue block7;
                }
                case '-': {
                    sb.append("\\-");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

