/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.context.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.BaseContextImpl;

public class ContextImpl
extends BaseContextImpl
implements Context,
Serializable {
    private static final long serialVersionUID = -6522200746253638309L;
    private Map<String, Context> subContextMap = new ConcurrentHashMap<String, Context>();
    private Context parent = null;

    public ContextImpl() {
    }

    public ContextImpl(Map map) {
        super.setItemMap(map);
    }

    @Override
    public Context getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Context parent) {
        this.parent = parent;
    }

    @Override
    public Context createSubContext(String contextName) {
        ContextImpl context = new ContextImpl();
        this.putSubContextAndSetParent(contextName, context);
        return context;
    }

    @Override
    public Context putSubContext(String contextName, Context context) {
        this.putSubContextAndSetParent(contextName, context);
        return context;
    }

    public void putContext(String contextName, Context context) {
        this.subContextMap.put(contextName, context);
    }

    private void putSubContextAndSetParent(String contextName, Context context) {
        context.setParent(this);
        this.subContextMap.put(contextName, context);
    }

    @Override
    public Context removeSubContext(String contextName) {
        return this.subContextMap.remove(contextName);
    }

    @Override
    public Context getSubContext(String contextName) {
        return this.subContextMap.get(contextName);
    }

    @Override
    public void clearSubContext() {
        this.subContextMap.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.clearSubContext();
    }

    @Override
    public Map<String, Context> getSubContextMap() {
        return this.subContextMap;
    }

    @Override
    public <T> T remove(String contextName, String name) {
        Context subContext = this.subContextMap.get(contextName);
        if (subContext != null) {
            return subContext.remove(name);
        }
        return null;
    }

    @Override
    public <T> T getInSubContext(String contextName, String name) {
        Context subContext = this.subContextMap.get(contextName);
        if (subContext != null) {
            return subContext.get(name);
        }
        return null;
    }

    @Override
    public <T> T put(String contextName, String name, T object) {
        Context subContext = this.subContextMap.get(contextName);
        if (subContext == null) {
            subContext = this.createSubContext(contextName);
        }
        subContext.put(name, object);
        return object;
    }

    @Override
    public <T> T get(String name) {
        HashMap<Context, String> nodeMap = new HashMap<Context, String>();
        if (nodeMap.get(this) == null) {
            return this.findNodeMap(name, this, nodeMap);
        }
        return null;
    }

    @Override
    public Map<String, Object> getTotalItemMap() {
        ArrayList<Context> list = new ArrayList<Context>();
        this.getTotalContext(this, list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = list.size() - 1; i >= 0; --i) {
            map.putAll(((Context)list.get(i)).getItemMap());
        }
        return map;
    }

    protected void getTotalContext(Context contextNode, List<Context> list) {
        if (list.contains(contextNode)) {
            return;
        }
        list.add(contextNode);
        for (Context subContext : contextNode.getSubContextMap().values()) {
            this.getTotalContext(subContext, list);
        }
        if (contextNode.getParent() != null) {
            this.getTotalContext(contextNode.getParent(), list);
        }
    }

    protected <T> T findNodeMap(String name, Context contextNode, Map<Context, String> nodeMap) {
        Context theParent;
        if (contextNode.getItemMap().containsKey(name)) {
            Object object = contextNode.getItemMap().get(name);
            if (object == null) {
                return null;
            }
            return (T)object;
        }
        Object result = contextNode.getItemMap().get(name);
        if (result != null) {
            return (T)result;
        }
        nodeMap.put(contextNode, "");
        if (!contextNode.getSubContextMap().isEmpty()) {
            for (Context context : contextNode.getSubContextMap().values()) {
                T subResult;
                if (nodeMap.get(context) != null || (subResult = this.findNodeMap(name, context, nodeMap)) == null) continue;
                return subResult;
            }
        }
        if ((theParent = contextNode.getParent()) != null && nodeMap.get(theParent) == null) {
            return this.findNodeMap(name, theParent, nodeMap);
        }
        return null;
    }

    protected boolean existNodeMap(String name, Context contextNode, Map<Context, String> nodeMap) {
        Context theParent;
        if (contextNode.getItemMap().containsKey(name)) {
            return true;
        }
        nodeMap.put(contextNode, "");
        if (!contextNode.getSubContextMap().isEmpty()) {
            for (Context context : contextNode.getSubContextMap().values()) {
                boolean exist;
                if (nodeMap.get(context) != null || !(exist = this.existNodeMap(name, context, nodeMap))) continue;
                return true;
            }
        }
        if ((theParent = contextNode.getParent()) != null && nodeMap.get(theParent) == null) {
            return this.existNodeMap(name, theParent, nodeMap);
        }
        return false;
    }

    protected Context containNodeMap(String name, Context contextNode, Map<Context, String> nodeMap) {
        Context theParent;
        if (contextNode.getItemMap().containsKey(name)) {
            return contextNode;
        }
        nodeMap.put(contextNode, "");
        if (!contextNode.getSubContextMap().isEmpty()) {
            for (Context context : contextNode.getSubContextMap().values()) {
                Context con;
                if (nodeMap.get(context) != null || (con = this.containNodeMap(name, context, nodeMap)) == null) continue;
                return con;
            }
        }
        if ((theParent = contextNode.getParent()) != null && nodeMap.get(theParent) == null) {
            return this.containNodeMap(name, theParent, nodeMap);
        }
        return null;
    }

    @Override
    public boolean renameKey(String key, String newKey) {
        HashMap<Context, String> nodeMap = new HashMap<Context, String>();
        if (nodeMap.get(this) == null) {
            return this.renameKeyNodeMap(key, newKey, this, nodeMap);
        }
        return false;
    }

    protected boolean renameKeyNodeMap(String key, String newKey, Context contextNode, Map<Context, String> nodeMap) {
        boolean renamed = this.renameKeyOfSuper(key, newKey, contextNode);
        Context theParent = contextNode.getParent();
        if (renamed) {
            return true;
        }
        nodeMap.put(contextNode, "");
        if (!contextNode.getSubContextMap().isEmpty()) {
            for (Context context : contextNode.getSubContextMap().values()) {
                if (nodeMap.get(context) != null || !(renamed = this.renameKeyNodeMap(key, newKey, context, nodeMap))) continue;
                return true;
            }
        }
        return theParent != null && nodeMap.get(theParent) == null && (renamed = this.renameKeyNodeMap(key, newKey, theParent, nodeMap));
    }

    private boolean renameKeyOfSuper(String key, String newKey, Context context) {
        Map<String, Object> itemMap = context.getItemMap();
        if (itemMap.containsKey(key)) {
            itemMap.put(newKey, itemMap.get(key));
            itemMap.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean exist(String name) {
        HashMap<Context, String> nodeMap = new HashMap<Context, String>();
        return this.existNodeMap(name, this, nodeMap);
    }

    @Override
    public Context contain(String name) {
        HashMap<Context, String> nodeMap = new HashMap<Context, String>();
        return this.containNodeMap(name, this, nodeMap);
    }

    @Override
    public Map<String, Object> getItemMap() {
        return super.getItemMap();
    }
}

