/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplateHandler;
import org.springframework.web.util.UriUtils;

public class DefaultUriTemplateHandler
implements UriTemplateHandler {
    private String baseUrl;
    private boolean parsePath;
    private boolean strictEncoding;

    public void setBaseUrl(String baseUrl) {
        if (baseUrl != null) {
            UriComponents uriComponents = UriComponentsBuilder.fromUriString(baseUrl).build();
            Assert.hasText((String)uriComponents.getScheme(), (String)"'baseUrl' must have a scheme");
            Assert.hasText((String)uriComponents.getHost(), (String)"'baseUrl' must have a host");
            Assert.isNull((Object)uriComponents.getQuery(), (String)"'baseUrl' cannot have a query");
            Assert.isNull((Object)uriComponents.getFragment(), (String)"'baseUrl' cannot have a fragment");
        }
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setParsePath(boolean parsePath) {
        this.parsePath = parsePath;
    }

    public boolean shouldParsePath() {
        return this.parsePath;
    }

    public void setStrictEncoding(boolean strictEncoding) {
        this.strictEncoding = strictEncoding;
    }

    public boolean isStrictEncoding() {
        return this.strictEncoding;
    }

    @Override
    public URI expand(String uriTemplate, Map<String, ?> uriVariables) {
        UriComponentsBuilder uriComponentsBuilder = this.initUriComponentsBuilder(uriTemplate);
        UriComponents uriComponents = this.expandAndEncode(uriComponentsBuilder, uriVariables);
        return this.insertBaseUrl(uriComponents);
    }

    @Override
    public URI expand(String uriTemplate, Object ... uriVariables) {
        UriComponentsBuilder uriComponentsBuilder = this.initUriComponentsBuilder(uriTemplate);
        UriComponents uriComponents = this.expandAndEncode(uriComponentsBuilder, uriVariables);
        return this.insertBaseUrl(uriComponents);
    }

    protected UriComponentsBuilder initUriComponentsBuilder(String uriTemplate) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(uriTemplate);
        if (this.shouldParsePath() && !this.isStrictEncoding()) {
            List<String> pathSegments = builder.build().getPathSegments();
            builder.replacePath(null);
            for (String pathSegment : pathSegments) {
                builder.pathSegment(pathSegment);
            }
        }
        return builder;
    }

    protected UriComponents expandAndEncode(UriComponentsBuilder builder, Map<String, ?> uriVariables) {
        if (!this.isStrictEncoding()) {
            return builder.build().expand(uriVariables).encode();
        }
        HashMap<String, String> encodedUriVars = new HashMap<String, String>(uriVariables.size());
        for (Map.Entry<String, ?> entry : uriVariables.entrySet()) {
            encodedUriVars.put(entry.getKey(), this.encodeValue(entry.getValue()));
        }
        return builder.build().expand(encodedUriVars);
    }

    protected UriComponents expandAndEncode(UriComponentsBuilder builder, Object[] uriVariables) {
        if (!this.isStrictEncoding()) {
            return builder.build().expand(uriVariables).encode();
        }
        Object[] encodedUriVars = new Object[uriVariables.length];
        for (int i = 0; i < uriVariables.length; ++i) {
            encodedUriVars[i] = this.encodeValue(uriVariables[i]);
        }
        return builder.build().expand(encodedUriVars);
    }

    private String encodeValue(Object value) {
        String stringValue = value != null ? value.toString() : "";
        try {
            return UriUtils.encode(stringValue, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Failed to encode URI variable", ex);
        }
    }

    protected URI insertBaseUrl(UriComponents uriComponents) {
        String url = uriComponents.toUriString();
        if (this.getBaseUrl() != null && uriComponents.getHost() == null) {
            url = this.getBaseUrl() + url;
        }
        try {
            return new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid URL after inserting base URL: " + url, ex);
        }
    }
}

