/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;

public class ForwardedHeaderFilter
extends OncePerRequestFilter {
    private static final Set<String> FORWARDED_HEADER_NAMES = new HashSet<String>(4);
    private ContextPathHelper contextPathHelper;

    public void setContextPath(String contextPath) {
        Assert.notNull((Object)contextPath, (String)"'contextPath' must not be null");
        this.contextPathHelper = new ContextPathHelper(contextPath);
    }

    @Override
    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (!FORWARDED_HEADER_NAMES.contains(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)new ForwardedHeaderRequestWrapper(request, this.contextPathHelper), (ServletResponse)response);
    }

    static {
        FORWARDED_HEADER_NAMES.add("Forwarded");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Host");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Port");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Proto");
    }

    private static class ContextPathHelper {
        private final String contextPath;
        private final UrlPathHelper urlPathHelper;

        public ContextPathHelper(String contextPath) {
            Assert.notNull((Object)contextPath);
            this.contextPath = ContextPathHelper.sanitizeContextPath(contextPath);
            this.urlPathHelper = new UrlPathHelper();
            this.urlPathHelper.setUrlDecode(false);
            this.urlPathHelper.setRemoveSemicolonContent(false);
        }

        private static String sanitizeContextPath(String contextPath) {
            if ((contextPath = contextPath.trim()).isEmpty()) {
                return contextPath;
            }
            if (contextPath.equals("/")) {
                return "/";
            }
            if (contextPath.charAt(0) != '/') {
                contextPath = "/" + contextPath;
            }
            while (contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
            return contextPath;
        }

        public String getContextPath(HttpServletRequest request) {
            return this.contextPath;
        }

        public String getRequestUri(HttpServletRequest request) {
            String pathWithinApplication = this.urlPathHelper.getPathWithinApplication(request);
            if (this.contextPath.equals("/") && pathWithinApplication.startsWith("/")) {
                return pathWithinApplication;
            }
            return this.contextPath + pathWithinApplication;
        }
    }

    private static class ForwardedHeaderRequestWrapper
    extends HttpServletRequestWrapper {
        private final String scheme;
        private final boolean secure;
        private final String host;
        private final int port;
        private final String contextPath;
        private final String requestUri;
        private final StringBuffer requestUrl;
        private final Map<String, List<String>> headers;

        public ForwardedHeaderRequestWrapper(HttpServletRequest request, ContextPathHelper pathHelper) {
            super(request);
            ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request);
            UriComponents uriComponents = UriComponentsBuilder.fromHttpRequest(httpRequest).build();
            int port = uriComponents.getPort();
            this.scheme = uriComponents.getScheme();
            this.secure = "https".equals(this.scheme);
            this.host = uriComponents.getHost();
            this.port = port == -1 ? (this.secure ? 443 : 80) : port;
            this.contextPath = pathHelper != null ? pathHelper.getContextPath(request) : request.getContextPath();
            this.requestUri = pathHelper != null ? pathHelper.getRequestUri(request) : request.getRequestURI();
            this.requestUrl = ForwardedHeaderRequestWrapper.initRequestUrl(this.scheme, this.host, port, this.requestUri);
            this.headers = ForwardedHeaderRequestWrapper.initHeaders(request);
        }

        private static StringBuffer initRequestUrl(String scheme, String host, int port, String path) {
            StringBuffer sb = new StringBuffer();
            sb.append(scheme).append("://").append(host);
            sb.append(port == -1 ? "" : ":" + port);
            sb.append(path);
            return sb;
        }

        private static Map<String, List<String>> initHeaders(HttpServletRequest request) {
            LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                headers.put(name, Collections.list(request.getHeaders(name)));
            }
            for (String name : FORWARDED_HEADER_NAMES) {
                headers.remove(name);
            }
            return headers;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getServerName() {
            return this.host;
        }

        public int getServerPort() {
            return this.port;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getRequestURI() {
            return this.requestUri;
        }

        public StringBuffer getRequestURL() {
            return this.requestUrl;
        }

        public String getHeader(String name) {
            List<String> value = this.headers.get(name);
            return CollectionUtils.isEmpty(value) ? null : value.get(0);
        }

        public Enumeration<String> getHeaders(String name) {
            List<String> value = this.headers.get(name);
            return Collections.enumeration(value != null ? value : Collections.emptySet());
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(this.headers.keySet());
        }
    }
}

