/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpRangeResource;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class ResourceHttpMessageConverter
extends AbstractHttpMessageConverter<Resource> {
    private static final boolean jafPresent = ClassUtils.isPresent((String)"javax.activation.FileTypeMap", (ClassLoader)ResourceHttpMessageConverter.class.getClassLoader());

    public ResourceHttpMessageConverter() {
        super(MediaType.ALL);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return Resource.class.isAssignableFrom(clazz);
    }

    @Override
    protected Resource readInternal(Class<? extends Resource> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        if (InputStreamResource.class == clazz) {
            return new InputStreamResource(inputMessage.getBody());
        }
        if (clazz.isAssignableFrom(ByteArrayResource.class)) {
            byte[] body = StreamUtils.copyToByteArray((InputStream)inputMessage.getBody());
            return new ByteArrayResource(body);
        }
        throw new IllegalStateException("Unsupported resource class: " + clazz);
    }

    @Override
    protected MediaType getDefaultContentType(Resource resource) {
        if (jafPresent) {
            return ActivationMediaTypeFactory.getMediaType(resource);
        }
        return MediaType.APPLICATION_OCTET_STREAM;
    }

    @Override
    protected Long getContentLength(Resource resource, MediaType contentType) throws IOException {
        if (InputStreamResource.class == resource.getClass()) {
            return null;
        }
        long contentLength = resource.contentLength();
        if (contentLength > Integer.MAX_VALUE) {
            throw new IOException("Resource content too long (beyond Integer.MAX_VALUE): " + resource);
        }
        return contentLength < 0L ? null : Long.valueOf(contentLength);
    }

    @Override
    protected void writeInternal(Resource resource, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        outputMessage.getHeaders().add("Accept-Ranges", "bytes");
        if (resource instanceof HttpRangeResource) {
            this.writePartialContent((HttpRangeResource)resource, outputMessage);
        } else {
            this.writeContent(resource, outputMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeContent(Resource resource, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try {
            InputStream in = resource.getInputStream();
            try {
                StreamUtils.copy((InputStream)in, (OutputStream)outputMessage.getBody());
            }
            catch (NullPointerException nullPointerException) {
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePartialContent(HttpRangeResource resource, HttpOutputMessage outputMessage) throws IOException {
        Assert.notNull((Object)resource, (String)"Resource should not be null");
        List<HttpRange> ranges = resource.getHttpRanges();
        HttpHeaders responseHeaders = outputMessage.getHeaders();
        MediaType contentType = responseHeaders.getContentType();
        Long length = this.getContentLength(resource, contentType);
        if (ranges.size() == 1) {
            HttpRange range = ranges.get(0);
            long start = range.getRangeStart(length);
            long end = range.getRangeEnd(length);
            long rangeLength = end - start + 1L;
            responseHeaders.add("Content-Range", "bytes " + start + "-" + end + "/" + length);
            responseHeaders.setContentLength((int)rangeLength);
            InputStream in = resource.getInputStream();
            try {
                this.copyRange(in, outputMessage.getBody(), start, end);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        String boundaryString = MimeTypeUtils.generateMultipartBoundaryString();
        responseHeaders.set("Content-Type", "multipart/byteranges; boundary=" + boundaryString);
        OutputStream out = outputMessage.getBody();
        for (HttpRange range : ranges) {
            long start = range.getRangeStart(length);
            long end = range.getRangeEnd(length);
            InputStream in = resource.getInputStream();
            ResourceHttpMessageConverter.println(out);
            ResourceHttpMessageConverter.print(out, "--" + boundaryString);
            ResourceHttpMessageConverter.println(out);
            if (contentType != null) {
                ResourceHttpMessageConverter.print(out, "Content-Type: " + contentType.toString());
                ResourceHttpMessageConverter.println(out);
            }
            ResourceHttpMessageConverter.print(out, "Content-Range: bytes " + start + "-" + end + "/" + length);
            ResourceHttpMessageConverter.println(out);
            ResourceHttpMessageConverter.println(out);
            this.copyRange(in, out, start, end);
        }
        ResourceHttpMessageConverter.println(out);
        ResourceHttpMessageConverter.print(out, "--" + boundaryString + "--");
    }

    private static void println(OutputStream os) throws IOException {
        os.write(13);
        os.write(10);
    }

    private static void print(OutputStream os, String buf) throws IOException {
        os.write(buf.getBytes("US-ASCII"));
    }

    private void copyRange(InputStream in, OutputStream out, long start, long end) throws IOException {
        long skipped = in.skip(start);
        if (skipped < start) {
            throw new IOException("Skipped only " + skipped + " bytes out of " + start + " required.");
        }
        long bytesToCopy = end - start + 1L;
        byte[] buffer = new byte[4096];
        while (bytesToCopy > 0L) {
            int bytesRead = in.read(buffer);
            if ((long)bytesRead <= bytesToCopy) {
                out.write(buffer, 0, bytesRead);
                bytesToCopy -= (long)bytesRead;
            } else {
                out.write(buffer, 0, (int)bytesToCopy);
                bytesToCopy = 0L;
            }
            if (bytesRead != -1) continue;
            break;
        }
    }

    private static class ActivationMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = ActivationMediaTypeFactory.loadFileTypeMapFromContextSupportModule();

        private ActivationMediaTypeFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FileTypeMap loadFileTypeMapFromContextSupportModule() {
            ClassPathResource mappingLocation = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (mappingLocation.exists()) {
                InputStream inputStream = null;
                try {
                    inputStream = mappingLocation.getInputStream();
                    MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(inputStream);
                    return mimetypesFileTypeMap;
                }
                catch (IOException iOException) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return FileTypeMap.getDefaultFileTypeMap();
        }

        public static MediaType getMediaType(Resource resource) {
            String mediaType;
            String filename = resource.getFilename();
            if (filename != null && StringUtils.hasText((String)(mediaType = fileTypeMap.getContentType(filename)))) {
                return MediaType.parseMediaType(mediaType);
            }
            return null;
        }
    }
}

