/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpRange;
import org.springframework.util.Assert;

public class HttpRangeResource
implements Resource {
    private final List<HttpRange> httpRanges;
    private final Resource resource;

    public HttpRangeResource(List<HttpRange> httpRanges, Resource resource) {
        Assert.notEmpty(httpRanges, (String)"List of HTTP Ranges should not be empty");
        this.httpRanges = httpRanges;
        this.resource = resource;
    }

    public final List<HttpRange> getHttpRanges() {
        return this.httpRanges;
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public boolean isReadable() {
        return this.resource.isReadable();
    }

    public boolean isOpen() {
        return this.resource.isOpen();
    }

    public URL getURL() throws IOException {
        return this.resource.getURL();
    }

    public URI getURI() throws IOException {
        return this.resource.getURI();
    }

    public File getFile() throws IOException {
        return this.resource.getFile();
    }

    public long contentLength() throws IOException {
        return this.resource.contentLength();
    }

    public long lastModified() throws IOException {
        return this.resource.lastModified();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.resource.createRelative(relativePath);
    }

    public String getFilename() {
        return this.resource.getFilename();
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }
}

