/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.config;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.AsyncLoadBalancerAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.loadbalancer.blocking.retry.BlockingLoadBalancedRetryFactory;
import org.springframework.cloud.loadbalancer.config.LoadBalancerAutoConfiguration;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@LoadBalancerClients
@AutoConfigureAfter(value={LoadBalancerAutoConfiguration.class})
@AutoConfigureBefore(value={org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration.class, AsyncLoadBalancerAutoConfiguration.class})
@ConditionalOnClass(value={RestTemplate.class})
public class BlockingLoadBalancerClientAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={LoadBalancerClientFactory.class})
    @ConditionalOnMissingBean
    public LoadBalancerClient blockingLoadBalancerClient(LoadBalancerClientFactory loadBalancerClientFactory, LoadBalancerProperties properties) {
        return new BlockingLoadBalancerClient(loadBalancerClientFactory, properties);
    }

    @Configuration
    @ConditionalOnClass(value={RetryTemplate.class})
    @EnableConfigurationProperties(value={LoadBalancerProperties.class})
    protected static class BlockingLoadBalancerRetryConfig {
        protected BlockingLoadBalancerRetryConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        LoadBalancedRetryFactory loadBalancedRetryFactory(LoadBalancerProperties properties) {
            return new BlockingLoadBalancedRetryFactory(properties);
        }
    }
}

