/*
 * Decompiled with CFR 0.152.
 */
package spire.math.prime;

import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.package$;
import spire.math.prime.BitSet;
import spire.math.prime.FactorHeap;
import spire.math.prime.SieveSegment$;
import spire.math.prime.SieveUtil;

@ScalaSignature(bytes="\u0006\u0001\u0005Uw!B\u0001\u0003\u0011\u0003I\u0011\u0001D*jKZ,7+Z4nK:$(BA\u0002\u0005\u0003\u0015\u0001(/[7f\u0015\t)a!\u0001\u0003nCRD'\"A\u0004\u0002\u000bM\u0004\u0018N]3\u0004\u0001A\u0011!bC\u0007\u0002\u0005\u0019)AB\u0001E\u0001\u001b\ta1+[3wKN+w-\\3oiN\u00191B\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mK\")\u0001d\u0003C\u00013\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\b7-\u0011\r\u0011\"\u0001\u001d\u0003\u001d9\b.Z3mgA*\u0012!\b\t\u0004\u001fy\u0001\u0013BA\u0010\u0011\u0005\u0015\t%O]1z!\ty\u0011%\u0003\u0002#!\t\u0019\u0011J\u001c;\t\r\u0011Z\u0001\u0015!\u0003\u001e\u0003!9\b.Z3mgA\u0002\u0003b\u0002\u0014\f\u0003\u0003%\tiJ\u0001\u0006CB\u0004H.\u001f\u000b\bQ\u00055\u0016qVAY!\tQ\u0011F\u0002\u0003\r\u0005\u0001S3\u0003B\u0015\u000fWQ\u0001\"a\u0004\u0017\n\u00055\u0002\"a\u0002)s_\u0012,8\r\u001e\u0005\t_%\u0012)\u001a!C\u0001a\u0005)1\u000f^1siV\t\u0011\u0007\u0005\u00023g5\tA!\u0003\u00025\t\tA1+\u00194f\u0019>tw\r\u0003\u00057S\tE\t\u0015!\u00032\u0003\u0019\u0019H/\u0019:uA!A\u0001(\u000bBK\u0002\u0013\u0005\u0011(\u0001\u0004qe&lWm]\u000b\u0002uA\u0011!bO\u0005\u0003y\t\u0011aAQ5u'\u0016$\b\u0002\u0003 *\u0005#\u0005\u000b\u0011\u0002\u001e\u0002\u000fA\u0014\u0018.\\3tA!A\u0001)\u000bBK\u0002\u0013\u0005\u0001'\u0001\u0004dkR|gM\u001a\u0005\t\u0005&\u0012\t\u0012)A\u0005c\u000591-\u001e;pM\u001a\u0004\u0003\"\u0002\r*\t\u0003!E\u0003\u0002\u0015F\r\u001eCQaL\"A\u0002EBQ\u0001O\"A\u0002iBQ\u0001Q\"A\u0002EBQ!S\u0015\u0005\u0002)\u000bq![:Qe&lW\r\u0006\u0002L\u001dB\u0011q\u0002T\u0005\u0003\u001bB\u0011qAQ8pY\u0016\fg\u000eC\u0003P\u0011\u0002\u0007\u0011'A\u0001o\u0011\u0015\t\u0016\u0006\"\u0001S\u0003-I7oQ8na>\u001c\u0018\u000e^3\u0015\u0005-\u001b\u0006\"B(Q\u0001\u0004\t\u0004\"B+*\t\u00031\u0016aA:fiR\u0011qK\u0017\t\u0003\u001faK!!\u0017\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001fR\u0003\r!\r\u0005\u00069&\"\t!X\u0001\u0006k:\u001cX\r\u001e\u000b\u0003/zCQaT.A\u0002EBQ\u0001Y\u0015\u0005\u0002\u0005\f\u0011B\\3yi\u00063G/\u001a:\u0015\u0005E\u0012\u0007\"B(`\u0001\u0004\t\u0004\"\u00023*\t\u0003)\u0017\u0001B5oSR$2a\u00164p\u0011\u001597\r1\u0001i\u0003\u00151\u0017m\u001d;r!\tIGN\u0004\u0002\u000bU&\u00111NA\u0001\n'&,g/Z+uS2L!!\u001c8\u0003\u0017\u0019\u000b7\u000f\u001e$bGR|'o\u001d\u0006\u0003W\nAQ\u0001]2A\u0002E\fQa\u001d7poF\u0004\"A\u0003:\n\u0005M\u0014!A\u0003$bGR|'\u000fS3ba\")Q/\u000bC\u0001m\u0006I\u0011N\\5u\u001b>$7\u0007\r\u000b\u0002/\")\u00010\u000bC\u0005s\u0006i\u0011N\\5u\rJ|W.\u0011:sCf$\"a\u0016>\t\u000b\u001d<\b\u0019\u00015\t\u000bqLC\u0011B?\u0002\u001b%t\u0017\u000e\u001e$s_6\fV/Z;f)\u00119f0!\u0001\t\u000b}\\\b\u0019A\u0019\u0002\u000b1LW.\u001b;\t\r\u0005\r1\u00101\u0001r\u0003\u0005\t\bfA>\u0002\bA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000eA\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t\"a\u0003\u0003\u000fQ\f\u0017\u000e\u001c:fG\"9\u0011QC\u0015\u0005\u0002\u0005]\u0011!C5oSR4\u0015N]:u)\u00159\u0016\u0011DA\u000e\u0011\u00199\u00171\u0003a\u0001Q\"1\u0001/a\u0005A\u0002EDq!a\b*\t\u0003\t\t#\u0001\u0005j]&$(+Z:u)\r9\u00161\u0005\u0005\u0007a\u0006u\u0001\u0019A9\t\u0013\u0005\u001d\u0012&!A\u0005\u0002\u0005%\u0012\u0001B2paf$r\u0001KA\u0016\u0003[\ty\u0003\u0003\u00050\u0003K\u0001\n\u00111\u00012\u0011!A\u0014Q\u0005I\u0001\u0002\u0004Q\u0004\u0002\u0003!\u0002&A\u0005\t\u0019A\u0019\t\u0013\u0005M\u0012&%A\u0005\u0002\u0005U\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003oQ3!MA\u001dW\t\tY\u0004\u0005\u0003\u0002>\u0005\rSBAA \u0015\u0011\t\t%a\u0003\u0002\u0013Ut7\r[3dW\u0016$\u0017\u0002BA#\u0003\u007f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tI%KI\u0001\n\u0003\tY%\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u00055#f\u0001\u001e\u0002:!I\u0011\u0011K\u0015\u0012\u0002\u0013\u0005\u0011QG\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\t)&KA\u0001\n\u0003\n9&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0002B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0003mC:<'BAA2\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0014Q\f\u0002\u0007'R\u0014\u0018N\\4\t\u0013\u0005-\u0014&!A\u0005\u0002\u00055\u0014\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001\u0011\t\u0013\u0005E\u0014&!A\u0005\u0002\u0005M\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003k\nY\bE\u0002\u0010\u0003oJ1!!\u001f\u0011\u0005\r\te.\u001f\u0005\n\u0003{\ny'!AA\u0002\u0001\n1\u0001\u001f\u00132\u0011%\t\t)KA\u0001\n\u0003\n\u0019)A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\t\u0005\u0004\u0002\b\u00065\u0015QO\u0007\u0003\u0003\u0013S1!a#\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\u000bII\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019*KA\u0001\n\u0003\t)*\u0001\u0005dC:,\u0015/^1m)\rY\u0015q\u0013\u0005\u000b\u0003{\n\t*!AA\u0002\u0005U\u0004\"CANS\u0005\u0005I\u0011IAO\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u0011\t\u0013\u0005\u0005\u0016&!A\u0005B\u0005\r\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0003\"CATS\u0005\u0005I\u0011IAU\u0003\u0019)\u0017/^1mgR\u00191*a+\t\u0015\u0005u\u0014QUA\u0001\u0002\u0004\t)\bC\u00030K\u0001\u0007\u0011\u0007C\u00039K\u0001\u0007!\bC\u0003AK\u0001\u0007\u0011\u0007C\u0005\u00026.\t\t\u0011\"!\u00028\u00069QO\\1qa2LH\u0003BA]\u0003\u000b\u0004RaDA^\u0003\u007fK1!!0\u0011\u0005\u0019y\u0005\u000f^5p]B1q\"!12uEJ1!a1\u0011\u0005\u0019!V\u000f\u001d7fg!I\u0011qYAZ\u0003\u0003\u0005\r\u0001K\u0001\u0004q\u0012\u0002\u0004\"CAf\u0017\u0005\u0005I\u0011BAg\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0007\u0003BA.\u0003#LA!a5\u0002^\t1qJ\u00196fGR\u0004")
public class SieveSegment
implements Product,
Serializable {
    private final SafeLong start;
    private final BitSet primes;
    private final SafeLong cutoff;

    public static int[] wheel30() {
        return SieveSegment$.MODULE$.wheel30();
    }

    public SafeLong start() {
        return this.start;
    }

    public BitSet primes() {
        return this.primes;
    }

    public SafeLong cutoff() {
        return this.cutoff;
    }

    public boolean isPrime(SafeLong n) {
        return this.primes().apply(n.$minus(this.start()).toInt());
    }

    public boolean isComposite(SafeLong n) {
        return !this.primes().apply(n.$minus(this.start()).toInt());
    }

    public void set(SafeLong n) {
        this.primes().$plus$eq(n.$minus(this.start()).toInt());
    }

    public void unset(SafeLong n) {
        this.primes().$minus$eq(n.$minus(this.start()).toInt());
    }

    public SafeLong nextAfter(SafeLong n) {
        int len = this.primes().length();
        for (int i = n.$minus(this.start()).$plus(2L).toInt(); i < len; i += 2) {
            if (!this.primes().apply(i)) continue;
            return this.start().$plus(i);
        }
        return SafeLong$.MODULE$.apply(-1L);
    }

    public void init(SieveUtil.FastFactors fastq, FactorHeap slowq) {
        this.initMod30();
        Integer n = BoxesRunTime.boxToInteger((int)0);
        SafeLong safeLong = this.start();
        boolean bl = safeLong != n ? (safeLong != null ? (!(safeLong instanceof Number) ? (!(safeLong instanceof Character) ? ((Object)((Object)safeLong)).equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)safeLong)), (Object)n)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)safeLong)), (Object)n)) : false) : true;
        if (bl) {
            this.initFirst(fastq, slowq);
        } else {
            SafeLong limit = package$.MODULE$.min(this.cutoff().$times$times(2), this.start().$plus(this.primes().length()), SafeLong$.MODULE$.SafeLongIsReal());
            this.initFromArray(fastq);
            this.initFromQueue(limit, slowq);
            this.initRest(slowq);
        }
    }

    public void initMod30() {
        int[] arr = this.primes().array();
        Predef$.MODULE$.assert(arr.length % 15 == 0);
        int limit = arr.length;
        int[] wheel = SieveSegment$.MODULE$.wheel30();
        for (int index$2 = 0; index$2 < limit; index$2 += 15) {
            System.arraycopy(wheel, 0, arr, index$2, 15);
        }
        Long l = BoxesRunTime.boxToLong((long)0L);
        SafeLong safeLong = this.start();
        boolean bl = safeLong != l ? (safeLong != null ? (!(safeLong instanceof Number) ? (!(safeLong instanceof Character) ? ((Object)((Object)safeLong)).equals(l) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)safeLong)), (Object)l)) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)safeLong)), (Object)l)) : false) : true;
        if (bl) {
            this.primes().$minus$eq(1);
            this.primes().$plus$eq(2);
            this.primes().$plus$eq(3);
            this.primes().$plus$eq(5);
        }
    }

    private void initFromArray(SieveUtil.FastFactors fastq) {
        long len;
        SieveUtil.FastFactor[] arr = fastq.arr();
        long l = len = this.start().$plus(this.primes().length()).$less((Object)this.cutoff()) ? this.cutoff().$minus(this.start()).toLong() : (long)this.primes().length();
        for (int i = 0; i < arr.length; ++i) {
            SieveUtil.FastFactor factor = arr[i];
            int j = factor.m().$minus(this.start()).toInt();
            int k = factor.p();
            int kk = k + k;
            long lim = len - (long)kk;
            this.primes().$minus$eq(j);
            while ((long)j < lim) {
                this.primes().$minus$eq(j += kk);
            }
            factor.m_$eq(this.start().$plus(j).$plus(kk));
        }
    }

    private void initFromQueue(SafeLong limit, FactorHeap q) {
        SieveUtil.Factor factor;
        while (true) {
            SafeLong safeLong;
            int i;
            if (q.isEmpty()) {
                return;
            }
            factor = q.dequeue();
            SafeLong m = factor.next();
            if (!m.$less((Object)limit)) break;
            SafeLong p = factor.p();
            int len = this.primes().length();
            if (p.$less((Object)SafeLong$.MODULE$.apply(len))) {
                int k = p.toInt();
                int kk = k + k;
                for (i = m.$minus(this.start()).toInt(); i < len; i += kk) {
                    this.primes().$minus$eq(i);
                }
                safeLong = this.start().$plus(i);
            } else {
                this.primes().$minus$eq(i);
                safeLong = m.$plus(p);
            }
            SafeLong m2 = safeLong;
            factor.next_$eq(m2);
            q.$plus$eq(factor);
        }
        q.$plus$eq(factor);
    }

    public void initFirst(SieveUtil.FastFactors fastq, FactorHeap slowq) {
        int len = this.primes().length();
        ArrayBuffer buf = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        for (int p = 1; p < len; p += 2) {
            BoxedUnit boxedUnit;
            if (this.primes().apply(p)) {
                long m = (long)p * (long)p;
                if (m < (long)len) {
                    int pp = p + p;
                    int k = (int)m;
                    this.primes().$minus$eq(k);
                    int lim = len - pp;
                    while (k < lim) {
                        this.primes().$minus$eq(k += pp);
                    }
                    m = (long)k + (long)pp;
                }
                if (p < 7) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (m - (long)this.primes().length() < (long)this.primes().length()) {
                    boxedUnit = buf.$plus$eq((Object)new SieveUtil.FastFactor(p, SafeLong$.MODULE$.apply(m)));
                    continue;
                }
                if (this.cutoff().$greater((Object)SafeLong$.MODULE$.apply(p))) {
                    slowq.$plus$eq(new SieveUtil.Factor(SafeLong$.MODULE$.apply(p), SafeLong$.MODULE$.apply(m)));
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        fastq.arr_$eq((SieveUtil.FastFactor[])buf.toArray(ClassTag$.MODULE$.apply(SieveUtil.FastFactor.class)));
    }

    public void initRest(FactorHeap slowq) {
        if (this.start().$greater$eq((Object)this.cutoff())) {
            return;
        }
        long len = this.start().$plus(this.primes().length()).$greater$eq((Object)this.cutoff()) ? this.cutoff().$minus(this.start()).toLong() : (long)this.primes().length();
        int i = 1;
        while ((long)i < len) {
            if (this.primes().apply(i)) {
                SafeLong p = this.start().$plus(i);
                slowq.$plus$eq(new SieveUtil.Factor(p, p.$times$times(2)));
            }
            i += 2;
        }
    }

    public SieveSegment copy(SafeLong start, BitSet primes, SafeLong cutoff) {
        return new SieveSegment(start, primes, cutoff);
    }

    public SafeLong copy$default$1() {
        return this.start();
    }

    public BitSet copy$default$2() {
        return this.primes();
    }

    public SafeLong copy$default$3() {
        return this.cutoff();
    }

    public String productPrefix() {
        return "SieveSegment";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        switch (x$1) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.cutoff();
                break;
            }
            case 1: {
                object = this.primes();
                break;
            }
            case 0: {
                object = this.start();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SieveSegment;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        boolean bl;
        boolean bl2;
        if (this == x$1) return true;
        if (!(x$1 instanceof SieveSegment)) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        SieveSegment sieveSegment = (SieveSegment)x$1;
        SafeLong safeLong = sieveSegment.start();
        SafeLong safeLong2 = this.start();
        if (safeLong2 != safeLong) {
            if (safeLong2 == null) return false;
            bl2 = !(safeLong2 instanceof Number) ? (!(safeLong2 instanceof Character) ? ((Object)((Object)safeLong2)).equals((Object)safeLong) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)safeLong2)), (Object)((Object)safeLong))) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)safeLong2)), (Object)((Object)safeLong));
        } else {
            bl2 = true;
        }
        if (!bl2) return false;
        BitSet bitSet = this.primes();
        BitSet bitSet2 = sieveSegment.primes();
        if (bitSet == null) {
            if (bitSet2 != null) {
                return false;
            }
        } else if (!((Object)bitSet).equals(bitSet2)) return false;
        SafeLong safeLong3 = sieveSegment.cutoff();
        SafeLong safeLong4 = this.cutoff();
        if (safeLong4 != safeLong3) {
            if (safeLong4 == null) return false;
            bl = !(safeLong4 instanceof Number) ? (!(safeLong4 instanceof Character) ? ((Object)((Object)safeLong4)).equals((Object)safeLong3) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)safeLong4)), (Object)((Object)safeLong3))) : BoxesRunTime.equalsNumObject((Number)((Number)((Object)safeLong4)), (Object)((Object)safeLong3));
        } else {
            bl = true;
        }
        if (!bl) return false;
        if (!sieveSegment.canEqual(this)) return false;
        return true;
    }

    public SieveSegment(SafeLong start, BitSet primes, SafeLong cutoff) {
        this.start = start;
        this.primes = primes;
        this.cutoff = cutoff;
        Product.class.$init$((Product)this);
    }
}

