/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import spire.algebra.Order;
import spire.math.Algebraic;
import spire.math.Algebraic$;
import spire.math.AlgebraicAlgebra;
import spire.math.AlgebraicInstances;
import spire.math.AlgebraicInstances$class;
import spire.math.Bounded;
import spire.math.Interval;
import spire.math.NumberTag;
import spire.math.Point;
import spire.math.Polynomial;
import spire.math.Rational;
import spire.math.package$;
import spire.math.poly.RootIsolator$;
import spire.math.poly.Roots$;

public final class Algebraic$
implements AlgebraicInstances,
Serializable {
    public static final Algebraic$ MODULE$;
    private final Algebraic Zero;
    private final Algebraic One;
    private final double spire$math$Algebraic$$bits2dec;
    private final Order<java.math.BigDecimal> JBigDecimalOrder;
    private final BigInteger spire$math$Algebraic$$MaxIntValue;
    private final BigInteger spire$math$Algebraic$$MinIntValue;
    private final BigInteger spire$math$Algebraic$$MaxLongValue;
    private final BigInteger spire$math$Algebraic$$MinLongValue;
    private final AlgebraicAlgebra AlgebraicAlgebra;
    private final NumberTag.LargeTag<Algebraic> AlgebraicTag;

    static {
        new Algebraic$();
    }

    @Override
    public final AlgebraicAlgebra AlgebraicAlgebra() {
        return this.AlgebraicAlgebra;
    }

    @Override
    public final NumberTag.LargeTag<Algebraic> AlgebraicTag() {
        return this.AlgebraicTag;
    }

    @Override
    public final void spire$math$AlgebraicInstances$_setter_$AlgebraicAlgebra_$eq(AlgebraicAlgebra x$1) {
        this.AlgebraicAlgebra = x$1;
    }

    @Override
    public final void spire$math$AlgebraicInstances$_setter_$AlgebraicTag_$eq(NumberTag.LargeTag x$1) {
        this.AlgebraicTag = x$1;
    }

    public Algebraic Zero() {
        return this.Zero;
    }

    public Algebraic One() {
        return this.One;
    }

    public Algebraic apply(int n) {
        return new Algebraic(new Algebraic.Expr.ConstantLong(n));
    }

    public Algebraic apply(long n) {
        return new Algebraic(new Algebraic.Expr.ConstantLong(n));
    }

    public Algebraic apply(float n) {
        return this.apply((double)n);
    }

    public Algebraic apply(double n) {
        if (Double.isInfinite(n)) {
            throw new IllegalArgumentException("cannot construct inifinite Algebraic");
        }
        if (Double.isNaN(n)) {
            throw new IllegalArgumentException("cannot construct Algebraic from NaN");
        }
        return new Algebraic(new Algebraic.Expr.ConstantDouble(n));
    }

    public Algebraic apply(BigInt n) {
        return new Algebraic(new Algebraic.Expr.ConstantBigDecimal(scala.package$.MODULE$.BigDecimal().apply(n)));
    }

    public Algebraic apply(BigDecimal n) {
        return new Algebraic(new Algebraic.Expr.ConstantBigDecimal(n));
    }

    public Algebraic apply(Rational n) {
        return new Algebraic(new Algebraic.Expr.ConstantRational(n));
    }

    public Algebraic root(Polynomial<Rational> poly, int i) {
        block7: {
            Algebraic algebraic;
            block6: {
                Interval interval2;
                Polynomial<BigInt> zpoly;
                block5: {
                    if (i < 0) {
                        throw new ArithmeticException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid real root index: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                    }
                    zpoly = Roots$.MODULE$.removeFractions(poly);
                    Vector<Interval<Rational>> intervals = Roots$.MODULE$.isolateRoots(zpoly, RootIsolator$.MODULE$.BigIntRootIsolator());
                    if (i >= intervals.size()) {
                        throw new ArithmeticException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot extract root ", ", there are only ", " roots"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)intervals.size())})));
                    }
                    interval2 = (Interval)intervals.apply(i);
                    if (!(interval2 instanceof Point)) break block5;
                    Point point = (Point)interval2;
                    algebraic = new Algebraic(new Algebraic.Expr.ConstantRational((Rational)((Object)point.value())));
                    break block6;
                }
                if (!(interval2 instanceof Bounded)) break block7;
                Bounded bounded = (Bounded)interval2;
                algebraic = new Algebraic(new Algebraic.Expr.ConstantRoot(zpoly, i, (Rational)((Object)bounded.lower()), (Rational)((Object)bounded.upper())));
            }
            return algebraic;
        }
        throw new RuntimeException("invalid isolated root interval");
    }

    public Vector<Algebraic> roots(Polynomial<Rational> poly) {
        Polynomial<BigInt> zpoly = Roots$.MODULE$.removeFractions(poly);
        Vector<Interval<Rational>> intervals = Roots$.MODULE$.isolateRoots(zpoly, RootIsolator$.MODULE$.BigIntRootIsolator());
        return (Vector)((TraversableLike)intervals.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1)new Serializable(zpoly){
            public static final long serialVersionUID = 0L;
            private final Polynomial zpoly$1;

            public final Algebraic apply(Tuple2<Interval<Rational>, Object> x0$1) {
                block4: {
                    Algebraic algebraic;
                    block3: {
                        block2: {
                            if (x0$1 == null || !(x0$1._1() instanceof Point)) break block2;
                            Point point = (Point)x0$1._1();
                            algebraic = new Algebraic(new Algebraic.Expr.ConstantRational((Rational)((Object)point.value())));
                            break block3;
                        }
                        if (x0$1 == null || !(x0$1._1() instanceof Bounded)) break block4;
                        Bounded bounded = (Bounded)x0$1._1();
                        algebraic = new Algebraic(new Algebraic.Expr.ConstantRoot(this.zpoly$1, x0$1._2$mcI$sp(), (Rational)((Object)bounded.lower()), (Rational)((Object)bounded.upper())));
                    }
                    return algebraic;
                }
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid isolated root interval: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x0$1})));
            }
            {
                this.zpoly$1 = zpoly$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
    }

    public Algebraic unsafeRoot(Polynomial<BigInt> poly, int i, Rational lb, Rational ub) {
        return new Algebraic(new Algebraic.Expr.ConstantRoot(poly, i, lb, ub));
    }

    public Algebraic apply(String n) {
        return this.apply(scala.package$.MODULE$.BigDecimal().apply(new java.math.BigDecimal(n)));
    }

    public final java.math.BigDecimal nrootApprox(java.math.BigDecimal x, int n) {
        int k = package$.MODULE$.min(n, 306);
        int width = (int)(package$.MODULE$.ceil((double)x.unscaledValue().bitLength() * package$.MODULE$.log(2.0) / package$.MODULE$.log(10.0)) - 1.0);
        int safeWidth = width + (x.scale() - width) % k;
        double approx = new java.math.BigDecimal(x.unscaledValue().abs(), safeWidth).doubleValue();
        return new java.math.BigDecimal((double)x.signum() * package$.MODULE$.pow(approx, 1.0 / (double)k)).scaleByPowerOfTen(-(x.scale() - safeWidth) / k).round(MathContext.DECIMAL64);
    }

    private final java.math.BigDecimal nroot(java.math.BigDecimal signedValue, int k, Function1<java.math.BigDecimal, Object> getEps) {
        if (signedValue.compareTo(java.math.BigDecimal.ZERO) == 0) {
            return java.math.BigDecimal.ZERO;
        }
        java.math.BigDecimal value = signedValue.abs();
        java.math.BigDecimal n = new java.math.BigDecimal(k);
        java.math.BigDecimal init = this.nrootApprox(value, k);
        java.math.BigDecimal unsignedResult = this.loop$2(init, Integer.MIN_VALUE, java.math.BigDecimal.ZERO, k, getEps, value, n);
        return signedValue.signum() < 0 ? unsignedResult.negate() : unsignedResult;
    }

    public double spire$math$Algebraic$$bits2dec() {
        return this.spire$math$Algebraic$$bits2dec;
    }

    public final java.math.BigDecimal nroot(java.math.BigDecimal value, int n, MathContext mc) {
        java.math.BigDecimal result = this.nroot(value, n, (Function1<java.math.BigDecimal, Object>)new Serializable(mc){
            public static final long serialVersionUID = 0L;
            private final MathContext mc$1;

            public final int apply(java.math.BigDecimal x) {
                return x.scale() - (int)package$.MODULE$.ceil((double)x.unscaledValue().bitLength() * Algebraic$.MODULE$.spire$math$Algebraic$$bits2dec()) + this.mc$1.getPrecision() + 1;
            }
            {
                this.mc$1 = mc$1;
            }
        });
        return result.round(mc);
    }

    public final java.math.BigDecimal nroot(java.math.BigDecimal value, int n, int scale, RoundingMode roundingMode) {
        return this.nroot(value, n, (Function1<java.math.BigDecimal, Object>)new Serializable(scale){
            public static final long serialVersionUID = 0L;
            private final int scale$1;

            public final int apply(java.math.BigDecimal x$4) {
                return this.scale$1 + 1;
            }
            {
                this.scale$1 = scale$1;
            }
        }).setScale(scale, roundingMode);
    }

    private Order<java.math.BigDecimal> JBigDecimalOrder() {
        return this.JBigDecimalOrder;
    }

    public java.math.BigDecimal spire$math$Algebraic$$roundExact(Algebraic exact, java.math.BigDecimal approx, int scale, RoundingMode mode) {
        java.math.BigDecimal bigDecimal;
        if (approx.signum() == 0) {
            java.math.BigDecimal bigDecimal2;
            boolean bl;
            RoundingMode roundingMode = RoundingMode.UP;
            if (!(roundingMode != null ? !((Object)((Object)roundingMode)).equals((Object)mode) : mode != null)) {
                bl = true;
            } else {
                RoundingMode roundingMode2 = RoundingMode.CEILING;
                bl = !(roundingMode2 != null ? !((Object)((Object)roundingMode2)).equals((Object)mode) : mode != null);
            }
            if (bl && exact.signum() > 0) {
                bigDecimal2 = new java.math.BigDecimal(BigInteger.ONE, scale);
            } else {
                boolean bl2;
                RoundingMode roundingMode3 = RoundingMode.UP;
                if (!(roundingMode3 != null ? !((Object)((Object)roundingMode3)).equals((Object)mode) : mode != null)) {
                    bl2 = true;
                } else {
                    RoundingMode roundingMode4 = RoundingMode.FLOOR;
                    bl2 = !(roundingMode4 != null ? !((Object)((Object)roundingMode4)).equals((Object)mode) : mode != null);
                }
                bigDecimal2 = bl2 && exact.signum() < 0 ? new java.math.BigDecimal(BigInteger.ONE.negate(), scale) : approx.setScale(scale, RoundingMode.DOWN);
            }
            bigDecimal = bigDecimal2;
        } else if (approx.signum() > 0) {
            bigDecimal = this.roundPositive(exact, approx, scale, mode);
        } else {
            RoundingMode roundingMode;
            RoundingMode roundingMode5 = RoundingMode.CEILING;
            if (!(roundingMode5 != null ? !((Object)((Object)roundingMode5)).equals((Object)mode) : mode != null)) {
                roundingMode = RoundingMode.FLOOR;
            } else {
                RoundingMode roundingMode6 = RoundingMode.FLOOR;
                roundingMode = !(roundingMode6 != null ? !((Object)((Object)roundingMode6)).equals((Object)mode) : mode != null) ? RoundingMode.CEILING : mode;
            }
            bigDecimal = this.roundPositive(exact.unary_$minus(), approx.abs(), scale, roundingMode).negate();
        }
        return bigDecimal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private java.math.BigDecimal roundPositive(Algebraic exact, java.math.BigDecimal approx, int scale, RoundingMode mode) {
        java.math.BigDecimal bigDecimal;
        java.math.BigDecimal bigDecimal2;
        int cutoff;
        while (true) {
            if ((cutoff = approx.scale() - scale) == 0) {
                bigDecimal2 = approx;
                return bigDecimal2;
            }
            if (cutoff < 0) {
                bigDecimal2 = approx.setScale(scale, RoundingMode.DOWN);
                return bigDecimal2;
            }
            if (cutoff <= 18) break;
            approx = approx.setScale(scale + 18, RoundingMode.DOWN);
        }
        long unscale = package$.MODULE$.pow(10L, cutoff);
        BigInteger[] bigIntegerArray = approx.unscaledValue().divideAndRemainder(BigInteger.valueOf(unscale));
        Option option2 = Array$.MODULE$.unapplySeq((Object)bigIntegerArray);
        if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(2) != 0) throw new MatchError((Object)bigIntegerArray);
        Tuple2 tuple22 = new Tuple2(((SeqLike)option2.get()).apply(0), ((SeqLike)option2.get()).apply(1));
        BigInteger truncatedUnscaledValue = (BigInteger)tuple22._1();
        BigInteger bigRemainder = (BigInteger)tuple22._2();
        java.math.BigDecimal truncated = new java.math.BigDecimal(truncatedUnscaledValue, scale);
        long remainder = bigRemainder.longValue();
        RoundingMode roundingMode = RoundingMode.UNNECESSARY;
        if (!(roundingMode != null ? !((Object)((Object)roundingMode)).equals((Object)mode) : mode != null)) {
            bigDecimal = truncated;
        } else {
            boolean bl;
            RoundingMode roundingMode2 = RoundingMode.HALF_DOWN;
            if (!(roundingMode2 != null ? !((Object)((Object)roundingMode2)).equals((Object)mode) : mode != null)) {
                bl = true;
            } else {
                RoundingMode roundingMode3 = RoundingMode.HALF_UP;
                if (!(roundingMode3 != null ? !((Object)((Object)roundingMode3)).equals((Object)mode) : mode != null)) {
                    bl = true;
                } else {
                    RoundingMode roundingMode4 = RoundingMode.HALF_EVEN;
                    bl = !(roundingMode4 != null ? !((Object)((Object)roundingMode4)).equals((Object)mode) : mode != null);
                }
            }
            if (bl) {
                java.math.BigDecimal bigDecimal3;
                long dangerZoneStart = unscale / 2L - 1L;
                long dangerZoneStop = dangerZoneStart + 2L;
                if (remainder >= dangerZoneStart && remainder <= dangerZoneStop) {
                    boolean bl2;
                    BigDecimal splitter = scala.package$.MODULE$.BigDecimal().apply(new java.math.BigDecimal(truncatedUnscaledValue.multiply(BigInteger.TEN).add(BigInteger.valueOf(5L)), scale + 1));
                    int cmp = exact.compare(this.apply(splitter));
                    RoundingMode roundingMode5 = RoundingMode.HALF_DOWN;
                    if (!(roundingMode5 != null ? !((Object)((Object)roundingMode5)).equals((Object)mode) : mode != null)) {
                        bl2 = cmp > 0;
                    } else {
                        RoundingMode roundingMode6 = RoundingMode.HALF_UP;
                        if (!(roundingMode6 != null ? !((Object)((Object)roundingMode6)).equals((Object)mode) : mode != null)) {
                            bl2 = cmp >= 0;
                        } else {
                            RoundingMode roundingMode7 = RoundingMode.HALF_EVEN;
                            if (roundingMode7 != null ? !((Object)((Object)roundingMode7)).equals((Object)mode) : mode != null) throw new MatchError((Object)mode);
                            boolean bl3 = bl2 = cmp > 0 || cmp == 0 && truncatedUnscaledValue.testBit(0);
                        }
                    }
                    bigDecimal3 = bl2 ? truncated.add(this.epsilon$1(scale)) : truncated;
                } else {
                    bigDecimal3 = remainder < dangerZoneStart ? truncated : truncated.add(this.epsilon$1(scale));
                }
                bigDecimal = bigDecimal3;
            } else {
                boolean bl4;
                RoundingMode roundingMode8 = RoundingMode.CEILING;
                if (!(roundingMode8 != null ? !((Object)((Object)roundingMode8)).equals((Object)mode) : mode != null)) {
                    bl4 = true;
                } else {
                    RoundingMode roundingMode9 = RoundingMode.UP;
                    bl4 = !(roundingMode9 != null ? !((Object)((Object)roundingMode9)).equals((Object)mode) : mode != null);
                }
                if (bl4) {
                    bigDecimal = remainder <= 1L && exact.$less$eq(this.apply(scala.package$.MODULE$.BigDecimal().apply(truncated))) ? truncated : truncated.add(this.epsilon$1(scale));
                } else {
                    java.math.BigDecimal bigDecimal4;
                    boolean bl5;
                    RoundingMode roundingMode10 = RoundingMode.FLOOR;
                    if (!(roundingMode10 != null ? !((Object)((Object)roundingMode10)).equals((Object)mode) : mode != null)) {
                        bl5 = true;
                    } else {
                        RoundingMode roundingMode11 = RoundingMode.DOWN;
                        bl5 = !(roundingMode11 != null ? !((Object)((Object)roundingMode11)).equals((Object)mode) : mode != null);
                    }
                    if (!bl5) throw new MatchError((Object)mode);
                    if (remainder <= 0L) {
                        bigDecimal4 = exact.$less(this.apply(scala.package$.MODULE$.BigDecimal().apply(truncated))) ? truncated.subtract(this.epsilon$1(scale)) : truncated;
                    } else if (remainder >= unscale - 1L) {
                        java.math.BigDecimal roundedUp = truncated.add(this.epsilon$1(scale));
                        bigDecimal4 = exact.$greater$eq(this.apply(scala.package$.MODULE$.BigDecimal().apply(roundedUp))) ? roundedUp : truncated;
                    } else {
                        bigDecimal4 = truncated;
                    }
                    bigDecimal = bigDecimal4;
                }
            }
        }
        bigDecimal2 = bigDecimal;
        return bigDecimal2;
    }

    public BigInteger spire$math$Algebraic$$MaxIntValue() {
        return this.spire$math$Algebraic$$MaxIntValue;
    }

    public BigInteger spire$math$Algebraic$$MinIntValue() {
        return this.spire$math$Algebraic$$MinIntValue;
    }

    public BigInteger spire$math$Algebraic$$MaxLongValue() {
        return this.spire$math$Algebraic$$MaxLongValue;
    }

    public BigInteger spire$math$Algebraic$$MinLongValue() {
        return this.spire$math$Algebraic$$MinLongValue;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final java.math.BigDecimal loop$2(java.math.BigDecimal prev, int prevDigits, java.math.BigDecimal prevEps, int k$1, Function1 getEps$1, java.math.BigDecimal value$1, java.math.BigDecimal n$1) {
        while (true) {
            int digits;
            java.math.BigDecimal eps = (digits = BoxesRunTime.unboxToInt((Object)getEps$1.apply((Object)prev))) == prevDigits ? prevEps : java.math.BigDecimal.ONE.movePointLeft(digits);
            java.math.BigDecimal prevExp = prev.pow(k$1 - 1);
            java.math.BigDecimal delta = value$1.divide(prevExp, digits, RoundingMode.HALF_UP).subtract(prev).divide(n$1, digits, RoundingMode.HALF_UP);
            if (delta.abs().compareTo(eps) <= 0) {
                return prev;
            }
            prevEps = eps;
            prevDigits = digits;
            prev = prev.add(delta);
        }
    }

    private final java.math.BigDecimal epsilon$1(int scale$2) {
        return new java.math.BigDecimal(BigInteger.ONE, scale$2);
    }

    private Algebraic$() {
        MODULE$ = this;
        AlgebraicInstances$class.$init$(this);
        this.Zero = new Algebraic(new Algebraic.Expr.ConstantLong(0L));
        this.One = new Algebraic(new Algebraic.Expr.ConstantLong(1L));
        this.spire$math$Algebraic$$bits2dec = package$.MODULE$.log(2.0, 10);
        this.JBigDecimalOrder = new anon.1();
        this.spire$math$Algebraic$$MaxIntValue = BigInteger.valueOf(Integer.MAX_VALUE);
        this.spire$math$Algebraic$$MinIntValue = BigInteger.valueOf(Integer.MIN_VALUE);
        this.spire$math$Algebraic$$MaxLongValue = BigInteger.valueOf(Long.MAX_VALUE);
        this.spire$math$Algebraic$$MinLongValue = BigInteger.valueOf(Long.MIN_VALUE);
    }
}

