/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.matchers.ArrayEquals;
import org.mockito.internal.matchers.Equals;
import org.mockito.internal.matchers.EqualsFunction0;
import org.mockito.internal.matchers.EqualsFunction1;
import org.mockito.internal.progress.ThreadSafeMockingProgress2$;
import org.specs2.matcher.Matcher;
import org.specs2.mock.ArgumentMatcherAdapter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ArgumentsProcessor$ {
    public static final ArgumentsProcessor$ MODULE$;

    static {
        new ArgumentsProcessor$();
    }

    public Object[] expandArgs(MockitoMethod method, Object[] args) {
        int nParams = method.getParameterTypes().length;
        return args != null && args.length > nParams ? this.expandVarArgs(method.isVarArgs(), Arrays.copyOf(args, nParams)) : args;
    }

    public Object[] expandVarArgs(boolean isVarArgs, Object[] args) {
        Object[] objectArray;
        if (isVarArgs && !Predef$.MODULE$.refArrayOps(args).isEmpty() && (args[args.length - 1] == null || args[args.length - 1].getClass().isArray())) {
            int nonVarArgsCount = args.length - 1;
            Object[] varArgs = null;
            varArgs = args[nonVarArgsCount] == null ? new Object[]{null} : ArrayEquals.createObjectArray((Object)args[nonVarArgsCount]);
            int varArgsCount = varArgs.length;
            Object[] newArgs = (Object[])Array$.MODULE$.ofDim(nonVarArgsCount + varArgsCount, ClassTag$.MODULE$.Object());
            System.arraycopy(args, 0, newArgs, 0, nonVarArgsCount);
            System.arraycopy(varArgs, 0, newArgs, nonVarArgsCount, varArgsCount);
            objectArray = newArgs;
        } else {
            objectArray = args == null ? (Object[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Object()) : args;
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public List<ArgumentMatcher<?>> argumentsToMatchers(Object[] arguments) {
        void var2_2;
        ArrayList matchers = new ArrayList(arguments.length);
        Predef$.MODULE$.refArrayOps(arguments).foreach((Function1)new Serializable(matchers){
            public static final long serialVersionUID = 0L;
            private final List matchers$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(Object arg) {
                Object object;
                Boolean bl;
                if (arg != null && arg.getClass().isArray()) {
                    bl = BoxesRunTime.boxToBoolean((boolean)this.matchers$1.add(new ArrayEquals(arg)));
                    return bl;
                }
                if (arg != null && arg.getClass().getName().startsWith("scala.collection.mutable.WrappedArray")) {
                    bl = BoxesRunTime.boxToBoolean((boolean)this.matchers$1.add(new Equals(arg)));
                    return bl;
                }
                if (arg instanceof Function0) {
                    Function0 function0 = (Function0)arg;
                    if (ArgumentsProcessor$.MODULE$.isCallRealMethod()) {
                        bl = BoxedUnit.UNIT;
                        return bl;
                    }
                    try {
                        object = function0.apply();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                    }
                } else {
                    if (arg instanceof Matcher) {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.matchers$1.add(new ArgumentMatcherAdapter<T>((Matcher)arg)));
                        return bl;
                    }
                    if (arg instanceof Seq || arg instanceof Set) {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.matchers$1.add(new Equals(arg)));
                        return bl;
                    }
                    if (arg instanceof AbstractFunction1) {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.matchers$1.add(new EqualsFunction1(arg)));
                        return bl;
                    }
                    bl = BoxesRunTime.boxToBoolean((boolean)this.matchers$1.add(new Equals(arg)));
                    return bl;
                }
                Object value = object;
                Buffer after = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ThreadSafeMockingProgress2$.MODULE$.pullLocalizedMatchers()).asScala();
                List argumentsMatchers = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)after.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArgumentMatcher<?> apply(ArgumentMatcher<?> m) {
                        return ArgumentsProcessor$.MODULE$.adaptFunction0(m);
                    }
                }, Buffer$.MODULE$.canBuildFrom())).asJava();
                if (argumentsMatchers.isEmpty()) {
                    bl = BoxesRunTime.boxToBoolean((boolean)this.matchers$1.add(new EqualsFunction0(value)));
                    return bl;
                }
                this.matchers$1.addAll(argumentsMatchers);
                ThreadSafeMockingProgress2$.MODULE$.reportMatchers(argumentsMatchers);
                bl = BoxedUnit.UNIT;
                return bl;
            }
            {
                this.matchers$1 = matchers$1;
            }
        });
        return var2_2;
    }

    public boolean isCallRealMethod() {
        return Predef$.MODULE$.refArrayOps((Object[])new Exception().getStackTrace()).toList().exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(StackTraceElement t) {
                String string = t.getClassName();
                String string2 = "org.mockito.internal.invocation.InterceptedInvocation";
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = t.getMethodName();
                String string4 = "callRealMethod";
                if (string3 == null) {
                    if (string4 == null) return true;
                    return false;
                } else {
                    if (!string3.equals(string4)) return false;
                    return true;
                }
            }
        });
    }

    public ArgumentMatcher<?> adaptFunction0(ArgumentMatcher<?> m) {
        return new ArgumentMatcher<Object>(m){
            private final ArgumentMatcher m$1;

            public boolean matches(Object a) {
                boolean bl;
                if (a instanceof Function0) {
                    Object value = ((Function0)a).apply();
                    bl = this.m$1.matches(value);
                } else {
                    bl = this.m$1.matches(a);
                }
                return bl;
            }
            {
                this.m$1 = m$1;
            }
        };
    }

    private ArgumentsProcessor$() {
        MODULE$ = this;
    }
}

