/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import java.util.ArrayList;
import java.util.List;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.dialect.DialectManager;
import org.rythmengine.internal.parser.Directive;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.ExpressionParser;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.F;
import org.rythmengine.utils.S;

public class ArgsParser
extends KeywordParserFactory {
    public static final String PATTERN = "\\G[ \\t\\x0B\\f]*,?[ \\t\\x0B\\f]*(([\\sa-zA-Z_][\\w$_\\.]*(?@\\<\\>)?(\\[\\])?)[ \\t\\x0B\\f]+([@a-zA-Z_][\\w$_]*))([ \\t\\x0B\\f]*=[ \\t\\x0B\\f]*(new[ \\t\\x0B\\f]+)?((?@{})|[0-9]+[fLld]?|'[.]'|(?@\"\")|[a-zA-Z_][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*(\\.[a-zA-Z][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*)*))?";
    public static final String PATTERN2 = "";

    @Override
    public Keyword keyword() {
        return Keyword.ARGS;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            public Token go2(String s) {
                Regex r = ArgsParser.this.reg(this.dialect());
                final ArrayList<F.T4<Integer, String, String, String>> ral = new ArrayList<F.T4<Integer, String, String, String>>();
                s = s.replaceAll("[\\n\\r]+", ",").replaceAll("[,]+", ",");
                int line = ctx.currentLine();
                while (r.search(s)) {
                    String defVal;
                    String type = r.stringMatched(2);
                    this.checkRestrictedClass(type);
                    String name = r.stringMatched(4);
                    String neu = r.stringMatched(6);
                    if (null == neu) {
                        neu = ArgsParser.PATTERN2;
                    }
                    if (null != (defVal = r.stringMatched(7))) {
                        defVal = neu + " " + defVal;
                    }
                    name = ExpressionParser.processPositionPlaceHolder(name);
                    ral.add(new F.T4<Integer, String, String, String>(line, type, name, defVal));
                }
                return new Directive(ArgsParser.PATTERN2, this.ctx()){

                    @Override
                    public void call() {
                        for (F.T4 rd : ral) {
                            this.builder().addRenderArgs((Integer)rd._1, (String)rd._2, (String)rd._3, (String)rd._4);
                        }
                    }
                };
            }

            @Override
            public Token go() {
                char c;
                String matched;
                String remain = this.remain();
                Regex r = new Regex(String.format("\\n?[ \\t\\x0B\\f]*%s%s(\\([ \t\f]*\\))?[ \t\f]*((?@{}))\\n?", this.a(), ArgsParser.this.keyword()));
                if (r.search(remain)) {
                    String matched2 = r.stringMatched();
                    if (matched2.startsWith("\n") || matched2.endsWith("\n")) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    }
                    String s = r.stringMatched(2);
                    s = S.strip(s, "{", "}");
                    this.step(matched2.length());
                    return this.go2(s);
                }
                boolean startWithLineBreak = remain.startsWith("\n");
                if (startWithLineBreak) {
                    remain = remain.substring(1);
                }
                String space = ArgsParser.PATTERN2;
                Regex r0 = new Regex("^(\\s+).*");
                if (r0.search(remain)) {
                    space = r0.stringMatched(1);
                }
                this.step(space.length());
                remain = remain.replaceFirst("^\\s+", ArgsParser.PATTERN2);
                String key = String.format("%s%s ", this.a(), ArgsParser.this.keyword());
                if (!remain.startsWith(key)) {
                    this.raiseParseException("No argument declaration found", new Object[0]);
                }
                this.step(key.length() + (startWithLineBreak ? 1 : 0));
                remain = this.remain();
                r = ArgsParser.this.reg(this.dialect());
                int step = 0;
                while (r.search(remain) && !(matched = r.stringMatched()).startsWith("\n") && !matched.startsWith("\r")) {
                    String defVal;
                    step += matched.length();
                    String type = r.stringMatched(2);
                    this.checkRestrictedClass(type);
                    String name = r.stringMatched(4);
                    String neu = r.stringMatched(6);
                    if (null == neu) {
                        neu = ArgsParser.PATTERN2;
                    }
                    if (null != (defVal = r.stringMatched(7))) {
                        defVal = neu + " " + defVal;
                    }
                    name = ExpressionParser.processPositionPlaceHolder(name);
                    this.ctx().getCodeBuilder().addRenderArgs(this.ctx().currentLine(), type, name, defVal);
                }
                this.step(step);
                while ((' ' == (c = this.peek()) || ';' == c || '\n' == c) && ctx.hasRemain()) {
                    this.step(1);
                    if (space.length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(space, ctx));
                    }
                    if ('\n' != c || !startWithLineBreak) continue;
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                }
                return new Directive(ArgsParser.PATTERN2, this.ctx()){

                    @Override
                    public void call() {
                    }
                };
            }
        };
    }

    public static List<CodeBuilder.RenderArgDeclaration> parseArgDeclaration(int lineNo, String s) {
        String matched;
        ArrayList<CodeBuilder.RenderArgDeclaration> ral = new ArrayList<CodeBuilder.RenderArgDeclaration>();
        Regex r = new ArgsParser().reg(DialectManager.current());
        while (r.search(s) && !(matched = r.stringMatched()).startsWith("\n") && !matched.startsWith("\r")) {
            String name = r.stringMatched(4);
            String type = r.stringMatched(2);
            String defVal = r.stringMatched(5);
            name = ExpressionParser.processPositionPlaceHolder(name);
            ral.add(new CodeBuilder.RenderArgDeclaration(lineNo, type, name, defVal));
        }
        return ral;
    }

    @Override
    protected String patternStr() {
        return PATTERN;
    }

    protected String patternStr0() {
        return "(%s%s([\\s,]+[a-zA-Z][a-zA-Z0-9_\\.]*(\\<[a-zA-Z][a-zA-Z0-9_\\.,]*\\>)?[\\s]+[a-zA-Z][a-zA-Z0-9_\\.]*)+(;|\\r?\\n)+).*";
    }
}

