/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rythmengine.RythmEngine;
import org.rythmengine.internal.compiler.ClassReloadException;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.internal.compiler.TemplateCompiler;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.ClasspathTemplateResource;
import org.rythmengine.resource.ITemplateResource;

public class TemplateClassManager {
    protected static final ILogger logger = Logger.get(TemplateClassManager.class);
    public RythmEngine engine = null;
    TemplateCompiler compiler = null;
    public Map<String, TemplateClass> clsNameIdx = new HashMap<String, TemplateClass>();
    public Map<Object, TemplateClass> tmplIdx = new HashMap<Object, TemplateClass>();

    public TemplateClassManager(RythmEngine engine) {
        if (null == engine) {
            throw new NullPointerException();
        }
        this.engine = engine;
        this.compiler = new TemplateCompiler(this);
    }

    public void clear() {
        this.clsNameIdx = new HashMap<String, TemplateClass>();
        this.tmplIdx = new HashMap<Object, TemplateClass>();
    }

    public List<TemplateClass> all() {
        return new ArrayList<TemplateClass>(this.clsNameIdx.values());
    }

    public TemplateClass getByClassName(String name) {
        TemplateClass tc = this.clsNameIdx.get(name);
        this.checkUpdate(tc);
        return tc;
    }

    public TemplateClass getByTemplate(Object name, boolean checkResource) {
        TemplateClass tc = this.tmplIdx.get(name);
        if (checkResource && null == tc) {
            ITemplateResource r = this.engine.resourceManager().getResource(name.toString());
            if (!r.isValid()) {
                return null;
            }
            tc = this.tmplIdx.get(r.getKey());
        }
        this.checkUpdate(tc);
        return tc;
    }

    public TemplateClass getByTemplate(Object name) {
        return this.getByTemplate(name, true);
    }

    private void checkUpdate(TemplateClass tc) {
        if (null == tc || this.engine.isProdMode()) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("checkUpdate for template: %s", tc.getKey());
        }
        try {
            this.engine.classLoader().detectChange(tc);
        }
        catch (ClassReloadException e) {
            this.engine.restart(e);
        }
    }

    List<TemplateClass> getEmbeddedClasses(String name) {
        ArrayList<TemplateClass> l = new ArrayList<TemplateClass>();
        for (Map.Entry<String, TemplateClass> entry : this.clsNameIdx.entrySet()) {
            if (!entry.getKey().startsWith(name + "$")) continue;
            l.add(entry.getValue());
        }
        return l;
    }

    @Deprecated
    public void add(Object key, TemplateClass templateClass) {
    }

    public void add(TemplateClass templateClass) {
        this.clsNameIdx.put(templateClass.name(), templateClass);
        if (!templateClass.isInner()) {
            String key2;
            ITemplateResource rsrc = templateClass.templateResource;
            Object key = rsrc.getKey();
            this.tmplIdx.put(key, templateClass);
            if (rsrc instanceof ClasspathTemplateResource && key != (key2 = ((ClasspathTemplateResource)rsrc).getKey2())) {
                this.tmplIdx.put(key2, templateClass);
            }
        }
    }

    public void remove(TemplateClass templateClass) {
        if (null == templateClass) {
            return;
        }
        if (templateClass.isInner()) {
            this.clsNameIdx.remove(templateClass.name());
            return;
        }
        this.clsNameIdx.remove(templateClass.name());
        String name0 = templateClass.name0();
        this.clsNameIdx.remove(name0);
        ArrayList<String> embedded = new ArrayList<String>();
        for (String cn : this.clsNameIdx.keySet()) {
            if (!cn.matches(name0 + "v[0-9]+\\$.*")) continue;
            embedded.add(cn);
        }
        for (String cn : embedded) {
            this.clsNameIdx.remove(cn);
        }
        if (null != templateClass && null != templateClass.templateResource) {
            this.tmplIdx.remove(templateClass.getKey());
        }
    }

    public void remove(String name) {
        TemplateClass templateClass = this.clsNameIdx.get(name);
        this.remove(templateClass);
    }

    public boolean hasClass(String name) {
        return this.clsNameIdx.containsKey(name);
    }

    public String toString() {
        return this.clsNameIdx.toString();
    }
}

