/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine;

import java.io.File;
import java.util.Map;
import java.util.Stack;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.sandbox.RythmSecurityManager;
import org.rythmengine.sandbox.SandboxExecutingService;

public class Sandbox {
    private static final ILogger logger = Logger.get(Sandbox.class);
    private static final InheritableThreadLocal<Boolean> sandboxMode = new InheritableThreadLocal();
    RythmEngine engine;
    SandboxExecutingService secureExecutor = null;
    private static boolean sandboxLive = false;
    private Map<String, Object> userContext;
    private static final ThreadLocal<Stack<Boolean>> restrictedZone = new ThreadLocal<Stack<Boolean>>(){

        @Override
        protected Stack<Boolean> initialValue() {
            return new Stack<Boolean>();
        }
    };

    static boolean sandboxMode() {
        Boolean mode = (Boolean)sandboxMode.get();
        return null == mode ? false : mode;
    }

    public static void turnOffSandbox(String code) {
        if (!sandboxLive) {
            return;
        }
        Sandbox.rsm().forbiddenIfCodeNotMatch(code);
        sandboxLive = false;
        System.setSecurityManager(null);
    }

    public Sandbox(RythmEngine engine, SandboxExecutingService executor) {
        this.engine = engine;
        this.secureExecutor = executor;
        sandboxLive = true;
        restrictedZone.set(new Stack());
    }

    private static RythmSecurityManager rsm() {
        return (RythmSecurityManager)System.getSecurityManager();
    }

    private RythmEngine engine() {
        if (null != this.engine) {
            return this.engine;
        }
        return Rythm.engine();
    }

    public Sandbox setUserContext(Map<String, Object> context) {
        this.userContext = context;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String render(String template, Object ... args) {
        sandboxMode.set(true);
        try {
            String string = this.secureExecutor.execute(this.userContext, template, args);
            return string;
        }
        finally {
            sandboxMode.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String render(File file, Object ... args) {
        sandboxMode.set(true);
        try {
            String string = this.secureExecutor.execute(this.userContext, file, args);
            return string;
        }
        finally {
            sandboxMode.remove();
        }
    }

    public static String hasAccessToRestrictedClasses(RythmEngine engine, String code) {
        for (String s : engine.conf().restrictedClasses()) {
            if (!code.contains(s)) continue;
            return s;
        }
        return null;
    }

    public static final void enterRestrictedZone(String code) {
        if (!sandboxLive || !Sandbox.sandboxMode()) {
            return;
        }
        Sandbox.rsm().forbiddenIfCodeNotMatch(code);
        restrictedZone.get().push(true);
    }

    public static final void enterSafeZone(String code) {
        if (!sandboxLive || !Sandbox.sandboxMode()) {
            return;
        }
        Sandbox.rsm().forbiddenIfCodeNotMatch(code);
        restrictedZone.get().push(false);
    }

    public static final void leaveCurZone(String code) {
        if (!sandboxLive || !Sandbox.sandboxMode()) {
            return;
        }
        Sandbox.rsm().forbiddenIfCodeNotMatch(code);
        Stack<Boolean> stack = restrictedZone.get();
        if (stack.isEmpty()) {
            throw new IllegalStateException("EMPTY ZONE");
        }
        stack.pop();
    }

    public static final boolean isRestricted() {
        if (!sandboxLive || !Sandbox.sandboxMode()) {
            return false;
        }
        Stack<Boolean> stack = restrictedZone.get();
        if (stack.isEmpty()) {
            return false;
        }
        return stack.peek();
    }
}

