/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla.cache;

import java.net.URL;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.olap4j.driver.xmla.cache.XmlaOlap4jCacheElement;
import org.olap4j.driver.xmla.cache.XmlaOlap4jNamedMemoryCache;
import org.olap4j.driver.xmla.cache.XmlaOlap4jShaEncoder;
import org.olap4j.impl.Olap4jUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlaOlap4jConcurrentMemoryCache {
    private static final int DEFAULT_CACHE_TIMEOUT = 60;
    private static final int DEFAULT_CACHE_SIZE = 10;
    private static final XmlaOlap4jNamedMemoryCache.Mode DEFAULT_EVICTION_MODE = XmlaOlap4jNamedMemoryCache.Mode.LFU;
    private Map<String, XmlaOlap4jCacheElement> cacheEntries = new ConcurrentHashMap<String, XmlaOlap4jCacheElement>();
    private int cacheSize = 10;
    private XmlaOlap4jNamedMemoryCache.Mode evictionMode = DEFAULT_EVICTION_MODE;
    private int cacheTimeout = 60;

    public XmlaOlap4jConcurrentMemoryCache(Map<String, String> props) throws IllegalArgumentException {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (XmlaOlap4jNamedMemoryCache.Property.SIZE.name().equalsIgnoreCase(entry.getKey().toString())) {
                this.setCacheSize(Integer.parseInt(entry.getValue().toString()));
                continue;
            }
            if (XmlaOlap4jNamedMemoryCache.Property.TIMEOUT.name().equalsIgnoreCase(entry.getKey().toString())) {
                this.setCacheTimeout(Integer.parseInt(entry.getValue().toString()));
                continue;
            }
            if (!XmlaOlap4jNamedMemoryCache.Property.MODE.name().equalsIgnoreCase(entry.getKey().toString())) continue;
            this.setCacheMode(entry.getValue().toString());
        }
    }

    private void setCacheSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Cache size must be positive, but was " + size);
        }
        this.cacheSize = size;
    }

    private void setCacheMode(String mode) {
        if (XmlaOlap4jNamedMemoryCache.Mode.valueOf(mode) == null) {
            throw new IllegalArgumentException("The XmlaOlap4jMemoryCache mode has to be one of " + XmlaOlap4jNamedMemoryCache.Mode.class.getName());
        }
        this.evictionMode = XmlaOlap4jNamedMemoryCache.Mode.valueOf(mode);
    }

    private void setCacheTimeout(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("Cache timeout must be positive, but was " + seconds);
        }
        this.cacheTimeout = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] get(URL url, byte[] request) {
        Map<String, XmlaOlap4jCacheElement> map = this.cacheEntries;
        synchronized (map) {
            this.cleanExpired(false);
            XmlaOlap4jCacheElement entry = this.cacheEntries.get(XmlaOlap4jShaEncoder.encodeSha1(url.toExternalForm() + new String(request)));
            if (entry != null) {
                entry.incrementHitCount();
                entry.refreshTimestamp();
            }
            return entry != null ? new String(entry.getResponse()).getBytes() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(URL url, byte[] request, byte[] response) {
        Map<String, XmlaOlap4jCacheElement> map = this.cacheEntries;
        synchronized (map) {
            this.cleanExpired(true);
            if (this.cacheEntries.size() >= this.cacheSize) {
                throw new RuntimeException("Concurrency error detected.");
            }
            XmlaOlap4jCacheElement entry = new XmlaOlap4jCacheElement();
            entry.setResponse(response);
            this.cacheEntries.put(XmlaOlap4jShaEncoder.encodeSha1(String.valueOf(url.toExternalForm()) + new String(request)), entry);
        }
    }

    private void cleanExpired(boolean makeRoom) {
        String toBeEvicted;
        switch (this.evictionMode) {
            case FIFO: 
            case LIFO: {
                toBeEvicted = this.timeBasedEviction(makeRoom);
                break;
            }
            case LFU: 
            case MFU: {
                toBeEvicted = this.hitBasedEviction(makeRoom);
                break;
            }
            default: {
                throw Olap4jUtil.unexpected((Enum)this.evictionMode);
            }
        }
        if (makeRoom && this.cacheEntries.size() >= this.cacheSize && toBeEvicted != null) {
            this.cacheEntries.remove(toBeEvicted);
        }
    }

    private String timeBasedEviction(boolean makeRoom) {
        long currentEvictedTimestamp = this.evictionMode == XmlaOlap4jNamedMemoryCache.Mode.LIFO ? Long.MAX_VALUE : Long.MIN_VALUE;
        String toBeEvicted = null;
        for (Map.Entry<String, XmlaOlap4jCacheElement> entry : this.cacheEntries.entrySet()) {
            if (Calendar.getInstance().getTimeInMillis() > entry.getValue().getTimestamp().longValue() + (long)(this.cacheTimeout * 1000)) {
                this.cacheEntries.remove(entry.getKey());
                continue;
            }
            if ((!makeRoom || this.evictionMode != XmlaOlap4jNamedMemoryCache.Mode.LIFO || entry.getValue().getTimestamp().longValue() >= currentEvictedTimestamp) && (!makeRoom || this.evictionMode != XmlaOlap4jNamedMemoryCache.Mode.FIFO || entry.getValue().getTimestamp().longValue() <= currentEvictedTimestamp)) continue;
            currentEvictedTimestamp = entry.getValue().getTimestamp().longValue();
            toBeEvicted = entry.getKey();
        }
        return toBeEvicted;
    }

    private String hitBasedEviction(boolean makeRoom) {
        long currentEvictedHits = this.evictionMode == XmlaOlap4jNamedMemoryCache.Mode.LFU ? Long.MAX_VALUE : Long.MIN_VALUE;
        String toBeEvicted = null;
        for (Map.Entry<String, XmlaOlap4jCacheElement> entry : this.cacheEntries.entrySet()) {
            if (Calendar.getInstance().getTimeInMillis() > entry.getValue().getTimestamp().longValue() + (long)(this.cacheTimeout * 1000)) {
                this.cacheEntries.remove(entry.getKey());
                continue;
            }
            if ((!makeRoom || this.evictionMode != XmlaOlap4jNamedMemoryCache.Mode.LFU || entry.getValue().getHitCount().longValue() >= currentEvictedHits) && (!makeRoom || this.evictionMode != XmlaOlap4jNamedMemoryCache.Mode.MFU || entry.getValue().getHitCount().longValue() <= currentEvictedHits)) continue;
            currentEvictedHits = entry.getValue().getHitCount().longValue();
            toBeEvicted = entry.getKey();
        }
        return toBeEvicted;
    }
}

