/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.pkg.container;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.annotation.pageannot.PageAnnot;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.res.Res;
import org.ofdrw.pkg.container.ResDir;
import org.ofdrw.pkg.container.VirtualContainer;

public class PageDir
extends VirtualContainer {
    public static final String PageContainerPrefix = "Page_";
    public static final String ContentFileName = "Content.xml";
    public static final String PageResFileName = "PageRes.xml";
    public static final String AnnotationFileName = "Annotation.xml";
    private int index = 0;

    public PageDir(Path fullDir) throws IllegalArgumentException {
        super(fullDir);
        String indexStr = this.getContainerName().replace(PageContainerPrefix, "");
        try {
            this.index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            this.clean();
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u76ee\u5f55\u540d\u79f0\uff1a" + this.getContainerName() + "\uff0c\u76ee\u5f55\u540d\u79f0\u5e94\u4e3a Page_N");
        }
    }

    public Integer getIndex() {
        return this.index;
    }

    public Res getPageRes() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(PageResFileName);
        return new Res(obj);
    }

    public PageDir setPageRes(Res pageRes) {
        this.putObj(PageResFileName, (Element)pageRes);
        return this;
    }

    public PageAnnot getPageAnnot() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(AnnotationFileName);
        return new PageAnnot(obj);
    }

    public PageDir setPageAnnot(PageAnnot pageAnnot) {
        this.putObj(AnnotationFileName, (Element)pageAnnot);
        return this;
    }

    public ResDir obtainRes() {
        return this.obtainContainer("Res", ResDir::new);
    }

    public ResDir getResDir() throws FileNotFoundException {
        return this.getContainer("Res", ResDir::new);
    }

    public PageDir add(Path resource) throws IOException {
        this.obtainRes().add(resource);
        return this;
    }

    public Path get(String name) throws FileNotFoundException {
        return this.obtainRes().getFile(name);
    }

    public Page getContent() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(ContentFileName);
        return new Page(obj);
    }

    public PageDir setContent(Page content) {
        this.putObj(ContentFileName, (Element)content);
        return this;
    }
}

