/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.ofdrw.layout.element.Div;

public class Img
extends Div {
    private Path src;

    private Img() {
        this.setIntegrity(true);
    }

    public Img(double width, double height, Path src) throws IOException {
        this(src);
        this.setWidth(width).setHeight(height);
    }

    @Deprecated
    public Img(Path src) throws IOException {
        this();
        if (src == null || Files.notExists(src, new LinkOption[0])) {
            throw new IllegalArgumentException("\u56fe\u7247\u6587\u4ef6\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
        }
        this.src = src;
        this.parseImg();
    }

    private void parseImg() throws IOException {
        File picture = this.src.toFile();
        BufferedImage imgObj = null;
        try (FileInputStream fIn = new FileInputStream(picture);){
            imgObj = ImageIO.read(fIn);
        }
        catch (IIOException e) {
            imgObj = Img.readImage(picture);
        }
        if (imgObj != null) {
            this.setWidth((double)imgObj.getWidth() / 5.0);
            this.setHeight((double)imgObj.getHeight() / 5.0);
        }
    }

    public static BufferedImage readImage(File imageFile) throws IOException {
        BufferedImage image;
        ImageInputStream input = ImageIO.createImageInputStream(imageFile);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
        if (readers == null || !readers.hasNext()) {
            return null;
        }
        ImageReader reader = readers.next();
        reader.setInput(input);
        try {
            image = reader.read(0);
        }
        catch (IIOException e) {
            image = Img.convertCMYK2RGB(reader);
        }
        return image;
    }

    private static BufferedImage convertCMYK2RGB(ImageReader reader) throws IOException {
        Raster raster = reader.readRaster(0, null);
        int w = raster.getWidth();
        int h = raster.getHeight();
        byte[] rgb = new byte[w * h * 3];
        float[] Y = raster.getSamples(0, 0, w, h, 0, (float[])null);
        float[] Cb = raster.getSamples(0, 0, w, h, 1, (float[])null);
        float[] Cr = raster.getSamples(0, 0, w, h, 2, (float[])null);
        float[] K = raster.getSamples(0, 0, w, h, 3, (float[])null);
        int i = 0;
        int imax = Y.length;
        int base = 0;
        while (i < imax) {
            float k = 220.0f - K[i];
            float y = 255.0f - Y[i];
            float cb = 255.0f - Cb[i];
            float cr = 255.0f - Cr[i];
            double val = (double)y + 1.402 * (double)(cr - 128.0f) - (double)k;
            rgb[base] = (byte)((val = (val - 128.0) * (double)0.65f + 128.0) < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y - 0.34414 * (double)(cb - 128.0f) - 0.71414 * (double)(cr - 128.0f) - (double)k;
            val = (val - 128.0) * (double)0.65f + 128.0;
            rgb[base + 1] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y + 1.772 * (double)(cb - 128.0f) - (double)k;
            val = (val - 128.0) * (double)0.65f + 128.0;
            rgb[base + 2] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            ++i;
            base += 3;
        }
        raster = Raster.createInterleavedRaster(new DataBufferByte(rgb, rgb.length), w, h, w * 3, 3, new int[]{0, 1, 2}, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, false, true, 1, 0);
        return new BufferedImage(cm, (WritableRaster)raster, true, null);
    }

    public Path getSrc() {
        return this.src;
    }

    public Img setSrc(Path src) {
        this.src = src;
        return this;
    }

    @Override
    public Div[] split(double sHeight) {
        throw new RuntimeException("\u56fe\u7247\u5bf9\u8c61\u4e0d\u652f\u6301\u5206\u5272\u64cd\u4f5c");
    }
}

