/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.ofdrw.converter.utils.OSinfo;
import org.ofdrw.converter.utils.StringUtils;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.reader.ResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontLoader {
    private static final Logger log = LoggerFactory.getLogger(FontLoader.class);
    private final Map<String, String> pathMapping = new ConcurrentHashMap<String, String>();
    private final Map<String, String> nameMapping = new ConcurrentHashMap<String, String>();
    private final Map<String, String> aliasMapping = new ConcurrentHashMap<String, String>();
    public static final String Separator = "$$$$";
    private static final String Empty = "null";
    private static final String DEFAULT_FONT_DIR_MAC = "/System/Library/Fonts";
    private static final String DEFAULT_FONT_DIR_WINDOWS = "C:/Windows/Fonts";
    private static final String DEFAULT_FONT_DIR_LINUX = "/usr/share/fonts";
    private static TrueTypeFont defaultFont;
    private static FontLoader instance;

    private FontLoader() {
    }

    private static synchronized void syncInit() {
        if (instance == null) {
            instance = new FontLoader();
            instance.init();
        }
    }

    public static FontLoader getInstance() {
        if (instance == null) {
            FontLoader.syncInit();
        }
        return instance;
    }

    public void init() {
        try (InputStream in = FontLoader.class.getResourceAsStream("/fonts/simsun.ttf");){
            defaultFont = new TTFParser(true).parse(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (OSinfo.isWindows()) {
            this.scanFontDir(new File(DEFAULT_FONT_DIR_WINDOWS));
        } else if (OSinfo.isMacOS()) {
            this.scanFontDir(new File(DEFAULT_FONT_DIR_MAC));
        } else if (OSinfo.isMacOSX()) {
            this.scanFontDir(new File(DEFAULT_FONT_DIR_MAC));
        } else if (OSinfo.isLinux()) {
            this.scanFontDir(new File(DEFAULT_FONT_DIR_LINUX));
        }
    }

    public FontLoader addAliasMapping(String familyName, String fontName, String aliasFamilyName, String aliasFontName) {
        if (familyName == null) {
            familyName = Empty;
        }
        if (fontName == null) {
            fontName = Empty;
        }
        if (aliasFamilyName == null) {
            aliasFamilyName = Empty;
        }
        if (aliasFontName == null) {
            aliasFontName = Empty;
        }
        String key1 = familyName + Separator + fontName;
        String key2 = aliasFamilyName + Separator + aliasFontName;
        if (this.nameMapping.get(key2) == null || this.pathMapping.get(key2) == null) {
            log.info("\u5b57\u4f53\u522b\u540d [{} {}] -> [{} {}] \u4e0d\u5b58\u5728", new Object[]{familyName, fontName, aliasFamilyName, aliasFontName});
            return this;
        }
        this.aliasMapping.put(key1, key2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemFontMapping(String familyName, String fontName, String fontFilePath) {
        File file;
        if (StringUtils.isBlank(familyName) || StringUtils.isBlank(fontName) || StringUtils.isBlank(fontFilePath)) {
            log.info("\u6dfb\u52a0\u7cfb\u7edf\u5b57\u4f53\u6620\u5c04\u5931\u8d25\uff0cFamilyName: {} FontName: {} \u8def\u5f84\uff1a{}", new Object[]{familyName, fontName, fontFilePath});
        }
        if (!(file = new File(fontFilePath)).exists() || file.isDirectory()) {
            log.info("\u6dfb\u52a0\u7cfb\u7edf\u5b57\u4f53\u6620\u5c04\u5931\u8d25\uff0c\u5b57\u4f53\u6587\u4ef6\uff1a{} \u4e0d\u5b58\u5728", (Object)fontFilePath);
        }
        if (!(file.getName().toLowerCase().endsWith("otf") || file.getName().toLowerCase().endsWith("ttf") || file.getName().toLowerCase().endsWith("ttc"))) {
            log.info("\u6dfb\u52a0\u7cfb\u7edf\u5b57\u4f53\u6620\u5c04\u5931\u8d25\uff0c{} \u4e0d\u662f\u4e00\u4e2aOpenType\u5b57\u4f53\u6587\u4ef6", (Object)fontFilePath);
        }
        Map<String, String> map = this.pathMapping;
        synchronized (map) {
            this.pathMapping.put(familyName + Separator + fontName, fontFilePath);
        }
    }

    public String getSystemFontPath(String familyName, String fontName) {
        String key;
        if (familyName == null) {
            familyName = Empty;
        }
        if (this.aliasMapping.get(key = familyName + Separator + fontName) != null) {
            return this.aliasMapping.get(key);
        }
        if (this.pathMapping.get(key) != null) {
            return this.pathMapping.get(key);
        }
        key = "null$$$$" + fontName;
        if (this.aliasMapping.get(key) != null) {
            return this.aliasMapping.get(key);
        }
        if (this.pathMapping.get(key) != null) {
            return this.pathMapping.get(key);
        }
        return null;
    }

    public TrueTypeFont loadSystemFont(String familyName, String fontName) {
        String fontFilePath = this.getSystemFontPath(familyName, fontName);
        if (fontFilePath == null) {
            log.info("\u52a0\u8f7d\u7cfb\u7edf\u5b57\u4f53\u5931\u8d25\uff1a[{} {}], \u5207\u6362\u81f3\u9ed8\u8ba4\u5b57\u4f53(\u5b8b\u4f53)", (Object)familyName, (Object)fontName);
            return this.loadDefaultFont();
        }
        TrueTypeFont ttf = this.loadExternalFont(fontFilePath, familyName, fontName);
        if (ttf == null) {
            return this.loadDefaultFont();
        }
        return ttf;
    }

    @Deprecated
    public TrueTypeFont loadExternalFont(String absPath) {
        return this.loadExternalFont(absPath, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TrueTypeFont loadExternalFont(String absPath, String familyName, String fontName) {
        try (FileInputStream in = new FileInputStream(absPath);){
            if (absPath.toLowerCase().endsWith(".ttf")) {
                TrueTypeFont trueTypeFont2 = new TTFParser(true).parse((InputStream)in);
                return trueTypeFont2;
            }
            if (absPath.toLowerCase().endsWith(".otf")) {
                OpenTypeFont openTypeFont = new OTFParser(true).parse((InputStream)in);
                return openTypeFont;
            }
            if (absPath.toLowerCase().endsWith(".ttc")) {
                TrueTypeCollection trueTypeCollection = new TrueTypeCollection((InputStream)in);
                TrueTypeFont res = trueTypeCollection.getFontByName(fontName);
                if (res == null) {
                    boolean[] flag = new boolean[]{false};
                    TrueTypeFont[] ttfHolder = new TrueTypeFont[]{null};
                    trueTypeCollection.processAllFonts(trueTypeFont -> {
                        if (flag[0]) {
                            return;
                        }
                        flag[0] = true;
                        ttfHolder[0] = trueTypeFont;
                    });
                    res = ttfHolder[0];
                }
                TrueTypeFont trueTypeFont3 = res;
                return trueTypeFont3;
            }
            log.info("\u4e0d\u652f\u6301\u7684\u5b57\u4f53\u683c\u5f0f\uff1a" + absPath);
            return null;
        }
        catch (IOException e) {
            log.info("\u5b57\u4f53 {},\u52a0\u8f7d\u5931\u8d25,\u539f\u56e0:{}", (Object)absPath, (Object)e.getMessage());
        }
        return null;
    }

    public TrueTypeFont loadFont(ResourceLocator rl, CT_Font ctFont) {
        if (ctFont == null) {
            return null;
        }
        try {
            ST_Loc fontFileLoc = ctFont.getFontFile();
            TrueTypeFont trueTypeFont = null;
            if (fontFileLoc != null) {
                String fontAbsPath = rl.getFile(ctFont.getFontFile()).toAbsolutePath().toString();
                trueTypeFont = this.loadExternalFont(fontAbsPath, ctFont.getFamilyName(), ctFont.getFontName());
            }
            if (trueTypeFont == null) {
                trueTypeFont = this.loadSystemFont(ctFont.getFamilyName(), ctFont.getFontName());
            }
            return trueTypeFont;
        }
        catch (Exception e) {
            log.info("\u65e0\u6cd5\u52a0\u8f7d\u5b57\u4f53: {} {} {}" + ctFont.getFamilyName(), (Object)ctFont.getFontName(), (Object)ctFont.getFontFile());
            return null;
        }
    }

    public TrueTypeFont loadDefaultFont() {
        return defaultFont;
    }

    public void scanFontDir(Path dir) {
        this.scanFontDir(dir.toFile());
    }

    public void scanFontDir(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.scanFontDir(file);
                continue;
            }
            this.loadFont(file);
        }
    }

    public void loadFont(Path file) {
        this.loadFont(file.toFile());
    }

    public void loadFont(File file) {
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith("ttc")) {
            try {
                TrueTypeCollection trueTypeCollection = new TrueTypeCollection(file);
                trueTypeCollection.processAllFonts(trueTypeFont -> {
                    NamingTable namingTable = trueTypeFont.getNaming();
                    this.addSystemFontMapping(namingTable, file.getPath());
                });
            }
            catch (IOException e) {
                log.info("\u65e0\u6cd5\u52a0\u8f7d\u5b57\u4f53\uff1a" + file.getAbsolutePath());
            }
            return;
        }
        if (!fileName.endsWith("otf") && !fileName.endsWith("ttf")) {
            return;
        }
        try {
            OTFParser parser = new OTFParser(true);
            OpenTypeFont openTypeFont = parser.parse(file);
            NamingTable namingTable = openTypeFont.getNaming();
            this.addSystemFontMapping(namingTable, file.getPath());
        }
        catch (Exception e) {
            log.info("\u65e0\u6cd5\u52a0\u8f7d\u5b57\u4f53\uff1a" + file.getAbsolutePath());
        }
    }

    private void addSystemFontMapping(NamingTable namingTable, String path) {
        String name = null;
        HashSet<String> familyNames = new HashSet<String>();
        HashSet<String> fontNames = new HashSet<String>();
        familyNames.add(namingTable.getFontFamily());
        fontNames.add(namingTable.getPostScriptName());
        name = namingTable.getPostScriptName();
        for (NameRecord record : namingTable.getNameRecords()) {
            if (record.getNameId() == 1) {
                familyNames.add(record.getString());
            } else if (record.getNameId() == 4) {
                fontNames.add(record.getString());
            }
            if (record.getLanguageId() != 0 || record.getNameId() != 4) continue;
            name = record.getString();
        }
        String finalName = name;
        for (String familyName : familyNames) {
            for (String fontName : fontNames) {
                this.nameMapping.put(familyName + Separator + fontName, finalName);
                this.nameMapping.put("null$$$$" + fontName, finalName);
                this.addSystemFontMapping(familyName, fontName, path);
                this.addSystemFontMapping(Empty, fontName, path);
            }
        }
    }

    static {
        instance = null;
    }
}

