/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.quartz;

import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class NutQuartzCronJobFactory {
    private static final Log log = Logs.get();
    protected PropertiesProxy conf;
    protected Scheduler scheduler;

    public void init() throws Exception {
        String prefix = "cron.";
        for (String key : this.conf.getKeys()) {
            if (key.length() < prefix.length() + 1 || !key.startsWith(prefix)) continue;
            String name = key.substring(prefix.length());
            String cron = this.conf.get(key);
            log.debugf("job define name=%s cron=%s", new Object[]{name, cron});
            Class<?> klass = null;
            klass = name.contains(".") ? Class.forName(name) : Class.forName(this.getClass().getPackage().getName() + ".job." + name);
            JobDetail job = JobBuilder.newJob(klass).build();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(name).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
            this.scheduler.scheduleJob(job, (Trigger)trigger);
        }
    }
}

