/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerators;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;

public enum IdType {
    STRING(true){

        @Override
        public Extractor<?> extractor(Extractors extractors) {
            return extractors.string();
        }

        @Override
        public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
            return IdMappers.strings(numberArrayFactory);
        }

        @Override
        public IdGenerator idGenerator() {
            return IdGenerators.startingFromTheBeginning();
        }
    }
    ,
    INTEGER(true){

        @Override
        public Extractor<?> extractor(Extractors extractors) {
            return extractors.long_();
        }

        @Override
        public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
            return IdMappers.longs(numberArrayFactory);
        }

        @Override
        public IdGenerator idGenerator() {
            return IdGenerators.startingFromTheBeginning();
        }
    }
    ,
    ACTUAL(false){

        @Override
        public Extractor<?> extractor(Extractors extractors) {
            return extractors.long_();
        }

        @Override
        public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
            return IdMappers.actual();
        }

        @Override
        public IdGenerator idGenerator() {
            return IdGenerators.fromInput();
        }
    };

    private final boolean idsAreExternal;

    private IdType(boolean idsAreExternal) {
        this.idsAreExternal = idsAreExternal;
    }

    public abstract IdMapper idMapper(NumberArrayFactory var1);

    public abstract IdGenerator idGenerator();

    public boolean idsAreExternal() {
        return this.idsAreExternal;
    }

    public abstract Extractor<?> extractor(Extractors var1);
}

