/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.File;
import java.nio.charset.Charset;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;

public class Inputs {
    public static Input input(final InputIterable<InputNode> nodes, final InputIterable<InputRelationship> relationships, final IdMapper idMapper, final IdGenerator idGenerator, final Collector badCollector) {
        return new Input(){

            @Override
            public InputIterable<InputRelationship> relationships() {
                return relationships;
            }

            @Override
            public InputIterable<InputNode> nodes() {
                return nodes;
            }

            @Override
            public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
                return idMapper;
            }

            @Override
            public IdGenerator idGenerator() {
                return idGenerator;
            }

            @Override
            public Collector badCollector() {
                return badCollector;
            }
        };
    }

    public static Input csv(File nodes, File relationships, IdType idType, Configuration configuration, Collector badCollector, int maxProcessors) {
        return new CsvInput(DataFactories.nodeData(DataFactories.data(InputEntityDecorators.NO_NODE_DECORATOR, Charset.defaultCharset(), nodes)), DataFactories.defaultFormatNodeFileHeader(), DataFactories.relationshipData(DataFactories.data(InputEntityDecorators.NO_RELATIONSHIP_DECORATOR, Charset.defaultCharset(), relationships)), DataFactories.defaultFormatRelationshipFileHeader(), idType, configuration, badCollector, maxProcessors);
    }
}

