/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class AssignRelationshipIdBatchStep
extends ProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    private long nextId;

    public AssignRelationshipIdBatchStep(StageControl control, Configuration config, long firstRelationshipId) {
        super(control, "ASSIGN", config, 1, new StatsProvider[0]);
        this.nextId = firstRelationshipId;
    }

    @Override
    protected void process(Batch<InputRelationship, RelationshipRecord> batch, BatchSender sender) throws Throwable {
        if (this.nextId <= 0xFFFFFFFFL && this.nextId + (long)((InputRelationship[])batch.input).length >= 0xFFFFFFFFL) {
            this.nextId = 0x100000000L;
        }
        batch.firstRecordId = this.nextId;
        sender.send(batch);
        this.nextId += (long)((InputRelationship[])batch.input).length;
    }

    public long getNextRelationshipId() {
        return this.nextId;
    }
}

