/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.function.ThrowingLongFunction;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;

public class PositionToRecoverFrom
implements ThrowingLongFunction<LogPosition, IOException> {
    public static final Monitor NO_MONITOR = new Monitor(){};
    private final LatestCheckPointFinder checkPointFinder;
    private final Monitor monitor;

    public PositionToRecoverFrom(LatestCheckPointFinder checkPointFinder, Monitor monitor) {
        this.checkPointFinder = checkPointFinder;
        this.monitor = monitor;
    }

    public LogPosition apply(long currentLogVersion) throws IOException {
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.checkPointFinder.find(currentLogVersion);
        if (!latestCheckPoint.commitsAfterCheckPoint) {
            this.monitor.noCommitsAfterLastCheckPoint(latestCheckPoint.checkPoint != null ? latestCheckPoint.checkPoint.getLogPosition() : null);
            return LogPosition.UNSPECIFIED;
        }
        if (latestCheckPoint.checkPoint != null) {
            this.monitor.commitsAfterLastCheckPoint(latestCheckPoint.checkPoint.getLogPosition(), latestCheckPoint.firstTxIdAfterLastCheckPoint);
            return latestCheckPoint.checkPoint.getLogPosition();
        }
        if (latestCheckPoint.oldestLogVersionFound != 0L) {
            long fromLogVersion = Math.max(0L, latestCheckPoint.oldestLogVersionFound);
            throw new UnderlyingStorageException("No check point found in any log file from version " + fromLogVersion + " to " + currentLogVersion);
        }
        this.monitor.noCheckPointFound();
        return LogPosition.start(0L);
    }

    public static interface Monitor {
        default public void noCommitsAfterLastCheckPoint(LogPosition logPosition) {
        }

        default public void commitsAfterLastCheckPoint(LogPosition logPosition, long firstTxIdAfterLastCheckPoint) {
        }

        default public void noCheckPointFound() {
        }
    }
}

