/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJob;
import org.neo4j.logging.LogProvider;

public class OnlineIndexSamplingJobFactory
implements IndexSamplingJobFactory {
    private final IndexStoreView storeView;
    private final LogProvider logProvider;
    private final TokenNameLookup nameLookup;

    public OnlineIndexSamplingJobFactory(IndexStoreView storeView, TokenNameLookup nameLookup, LogProvider logProvider) {
        this.storeView = storeView;
        this.logProvider = logProvider;
        this.nameLookup = nameLookup;
    }

    @Override
    public IndexSamplingJob create(long indexId, IndexProxy indexProxy) {
        String indexUserDescription = indexProxy.getDescriptor().userDescription(this.nameLookup);
        return new OnlineIndexSamplingJob(indexId, indexProxy, this.storeView, indexUserDescription, this.logProvider);
    }
}

