/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.stax;

import java.util.ArrayList;
import java.util.List;
import javanet.staxutils.events.AbstractCharactersEvent;
import javanet.staxutils.events.AttributeEvent;
import javanet.staxutils.events.CDataEvent;
import javanet.staxutils.events.CharactersEvent;
import javanet.staxutils.events.CommentEvent;
import javanet.staxutils.events.EndDocumentEvent;
import javanet.staxutils.events.EndElementEvent;
import javanet.staxutils.events.NamespaceEvent;
import javanet.staxutils.events.StartDocumentEvent;
import javanet.staxutils.events.StartElementEvent;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import org.mule.module.xml.stax.DelegateXMLStreamReader;
import org.mule.module.xml.stax.EndElementEventX;
import org.mule.module.xml.stax.MapNamespaceContext;
import org.mule.module.xml.stax.StartElementEventX;

public class ReversibleXMLStreamReader
extends DelegateXMLStreamReader {
    private List<XMLEvent> events;
    private XMLEvent current;
    private int replayIndex;
    private boolean tracking = false;
    private boolean replay = false;

    public ReversibleXMLStreamReader(XMLStreamReader reader) {
        super(reader);
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public void reset() {
        this.replay = true;
        this.replayIndex = 0;
        this.current = null;
    }

    public boolean isTracking() {
        return this.tracking;
    }

    public void setTracking(boolean tracking) {
        this.tracking = tracking;
        if (tracking) {
            this.replayIndex = 0;
            if (this.events == null) {
                this.events = new ArrayList<XMLEvent>();
            }
        }
    }

    @Override
    public int next() throws XMLStreamException {
        int event;
        if (this.replay) {
            if (this.replayIndex == this.events.size()) {
                this.replay = false;
                event = super.next();
            } else {
                event = this.getReplayEvent();
            }
        } else {
            event = super.next();
        }
        if (this.tracking && !this.replay) {
            this.capture(event);
        }
        return event;
    }

    private int getReplayEvent() {
        this.current = this.events.get(this.replayIndex);
        ++this.replayIndex;
        return this.current.getEventType();
    }

    private void capture(int event) {
        switch (event) {
            case 7: {
                this.events.add((XMLEvent)new StartDocumentEvent(this.getEncoding(), new Boolean(this.isStandalone()), this.getVersion(), this.getLocation()));
                break;
            }
            case 8: {
                this.events.add((XMLEvent)new EndDocumentEvent(this.getLocation()));
                break;
            }
            case 1: {
                this.events.add((XMLEvent)this.createStartElementEvent());
                break;
            }
            case 2: {
                this.events.add((XMLEvent)((Object)new EndElementEventX(this.getName(), this.getNamespaces())));
                break;
            }
            case 12: {
                this.events.add((XMLEvent)new CDataEvent(this.getText(), this.getLocation()));
                break;
            }
            case 4: {
                this.events.add((XMLEvent)new CharactersEvent(this.getText(), this.getLocation()));
                break;
            }
            case 5: {
                this.events.add((XMLEvent)new CommentEvent(this.getText(), this.getLocation()));
                break;
            }
            case 11: {
                break;
            }
            case 15: {
                break;
            }
            case 9: {
                break;
            }
            case 14: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private StartElementEvent createStartElementEvent() {
        ArrayList<AttributeEvent> attributes = new ArrayList<AttributeEvent>();
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            attributes.add(new AttributeEvent(this.getAttributeName(i), this.getAttributeValue(i)));
        }
        return new StartElementEventX(this.getName(), attributes, this.getNamespaces(), this.createContext(), this.getLocation(), null);
    }

    private NamespaceContext createContext() {
        MapNamespaceContext ctx = new MapNamespaceContext();
        for (int i = 0; i < this.getNamespaceCount(); ++i) {
            ctx.addNamespace(this.getNamespacePrefix(i), this.getNamespaceURI(i));
        }
        return ctx;
    }

    private List<Namespace> getNamespaces() {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (int i = 0; i < this.getNamespaceCount(); ++i) {
            namespaces.add((Namespace)new NamespaceEvent(this.getNamespacePrefix(i), this.getNamespaceURI(i), this.getLocation()));
        }
        return namespaces;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int eventType = this.next();
        StringBuilder buf = new StringBuilder();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                buf.append(this.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content");
                }
                if (eventType == 1) {
                    throw new XMLStreamException("element text content may not contain START_ELEMENT", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + eventType, this.getLocation());
            }
            eventType = this.next();
        }
        return buf.toString();
    }

    @Override
    public int getAttributeCount() {
        if (this.replay) {
            return ((StartElementEventX)((Object)this.current)).getAttributeList().size();
        }
        return super.getAttributeCount();
    }

    @Override
    public String getAttributeLocalName(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getName().getLocalPart();
        }
        return super.getAttributeLocalName(i);
    }

    @Override
    public QName getAttributeName(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getName();
        }
        return super.getAttributeName(i);
    }

    @Override
    public String getAttributeNamespace(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getName().getNamespaceURI();
        }
        return super.getAttributeNamespace(i);
    }

    @Override
    public String getAttributePrefix(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getName().getPrefix();
        }
        return super.getAttributePrefix(i);
    }

    @Override
    public String getAttributeType(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getDTDType();
        }
        return super.getAttributeType(i);
    }

    @Override
    public String getAttributeValue(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getValue();
        }
        return super.getAttributeValue(i);
    }

    @Override
    public String getAttributeValue(String ns, String local) {
        if (this.replay) {
            Attribute att = ((StartElementEventX)((Object)this.current)).getAttributeByName(new QName(ns, local));
            if (att != null) {
                return att.getValue();
            }
            return null;
        }
        return super.getAttributeValue(ns, local);
    }

    @Override
    public int getEventType() {
        if (this.replay) {
            if (this.current == null) {
                return -1;
            }
            return this.current.getEventType();
        }
        return super.getEventType();
    }

    @Override
    public String getLocalName() {
        if (this.replay) {
            if (this.isStartElement()) {
                return ((StartElementEventX)((Object)this.current)).getName().getLocalPart();
            }
            return ((EndElementEvent)this.current).getName().getLocalPart();
        }
        return super.getLocalName();
    }

    @Override
    public Location getLocation() {
        if (this.replay) {
            return this.current.getLocation();
        }
        return super.getLocation();
    }

    @Override
    public QName getName() {
        if (this.replay) {
            if (this.isStartElement()) {
                return ((StartElementEventX)((Object)this.current)).getName();
            }
            return ((EndElementEvent)this.current).getName();
        }
        return super.getName();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (this.replay) {
            return ((StartElementEventX)((Object)this.current)).getNamespaceContext();
        }
        return super.getNamespaceContext();
    }

    @Override
    public int getNamespaceCount() {
        if (this.replay) {
            if (this.isStartElement()) {
                return ((StartElementEventX)((Object)this.current)).getNamespaceList().size();
            }
            return ((EndElementEventX)((Object)this.current)).getNamespaceList().size();
        }
        return super.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int arg0) {
        if (this.replay) {
            if (this.isStartElement()) {
                Namespace ns = (Namespace)((StartElementEventX)((Object)this.current)).getNamespaceList().get(arg0);
                return ns.getPrefix();
            }
            Namespace ns = ((EndElementEventX)((Object)this.current)).getNamespaceList().get(arg0);
            return ns.getPrefix();
        }
        return super.getNamespacePrefix(arg0);
    }

    @Override
    public String getNamespaceURI() {
        if (this.replay) {
            if (this.isStartElement()) {
                return ((StartElementEventX)((Object)this.current)).getName().getNamespaceURI();
            }
            return ((EndElementEvent)this.current).getName().getNamespaceURI();
        }
        return super.getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(int arg0) {
        if (this.replay) {
            Namespace ns = (Namespace)((StartElementEventX)((Object)this.current)).getNamespaceList().get(arg0);
            return ns.getNamespaceURI();
        }
        return super.getNamespaceURI(arg0);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.replay) {
            return ((StartElementEventX)((Object)this.current)).getNamespaceURI(prefix);
        }
        return super.getNamespaceURI(prefix);
    }

    @Override
    public String getPIData() {
        if (this.replay) {
            return null;
        }
        return super.getPIData();
    }

    @Override
    public String getPITarget() {
        if (this.replay) {
            return null;
        }
        return super.getPITarget();
    }

    @Override
    public String getPrefix() {
        if (this.replay) {
            if (this.isStartElement()) {
                return ((StartElementEventX)((Object)this.current)).getName().getPrefix();
            }
            return ((EndElementEvent)this.current).getName().getPrefix();
        }
        return super.getPrefix();
    }

    @Override
    public String getText() {
        if (this.replay) {
            if (this.current instanceof CommentEvent) {
                return ((CommentEvent)this.current).getText();
            }
            return ((AbstractCharactersEvent)this.current).getData();
        }
        return super.getText();
    }

    @Override
    public char[] getTextCharacters() {
        if (this.replay) {
            return ((CharactersEvent)this.current).getData().toCharArray();
        }
        return super.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.replay) {
            char[] src = this.getText().toCharArray();
            if (sourceStart + length >= src.length) {
                length = src.length - sourceStart;
            }
            for (int i = 0; i < length; ++i) {
                target[targetStart + i] = src[i + sourceStart];
            }
            return length;
        }
        return super.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextLength() {
        if (this.replay) {
            return this.getText().length();
        }
        return super.getTextLength();
    }

    @Override
    public int getTextStart() {
        if (this.replay) {
            return 0;
        }
        return super.getTextStart();
    }

    @Override
    public boolean hasName() {
        if (this.replay) {
            return this.isStartElement() || this.isEndElement();
        }
        return super.hasName();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        if (this.replay) {
            if (this.replayIndex == this.events.size()) {
                return super.hasNext();
            }
            return true;
        }
        return super.hasNext();
    }

    @Override
    public boolean hasText() {
        if (this.replay) {
            int event = this.getEventType();
            return event == 4 || event == 11 || event == 9 || event == 5 || event == 6;
        }
        return super.hasText();
    }

    @Override
    public boolean isAttributeSpecified(int i) {
        if (this.replay) {
            Attribute attr = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return attr.isSpecified();
        }
        return super.isAttributeSpecified(i);
    }

    @Override
    public boolean isCharacters() {
        if (this.replay) {
            return this.current.isCharacters();
        }
        return super.isCharacters();
    }

    @Override
    public boolean isEndElement() {
        if (this.replay) {
            return this.current.isEndElement();
        }
        return super.isEndElement();
    }

    @Override
    public boolean isStartElement() {
        if (this.replay) {
            return this.current != null && this.current.isStartElement();
        }
        return super.isStartElement();
    }

    @Override
    public boolean isWhiteSpace() {
        if (this.replay) {
            if (this.current instanceof Characters) {
                return ((Characters)this.current).isWhiteSpace();
            }
            return this.current.getEventType() == 6;
        }
        return super.isWhiteSpace();
    }
}

