/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart;

import java.util.Collection;
import java.util.Collections;
import org.microbean.helm.chart.ChartException;
import org.microbean.helm.chart.Requirements;

public class MissingDependenciesException
extends ChartException {
    private static final String LS = System.getProperty("line.separator", "\n");
    private static final long serialVersionUID = 1L;
    private final Collection<? extends Requirements.Dependency> missingDependencies;

    public MissingDependenciesException() {
        this.missingDependencies = Collections.emptySet();
    }

    public MissingDependenciesException(Collection<? extends Requirements.Dependency> missingDependencies) {
        super(MissingDependenciesException.createMessage(missingDependencies));
        this.missingDependencies = missingDependencies == null ? Collections.emptySet() : Collections.unmodifiableCollection(missingDependencies);
    }

    public MissingDependenciesException(String message) {
        super(message);
        this.missingDependencies = Collections.emptySet();
    }

    public MissingDependenciesException(Throwable cause) {
        super(cause);
        this.missingDependencies = Collections.emptySet();
    }

    public MissingDependenciesException(String message, Throwable cause) {
        super(message, cause);
        this.missingDependencies = Collections.emptySet();
    }

    public final Collection<? extends Requirements.Dependency> getMissingDependencies() {
        return this.missingDependencies;
    }

    private static final String createMessage(Collection<? extends Requirements.Dependency> dependencies) {
        String returnValue = null;
        if (dependencies != null && !dependencies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Requirements.Dependency dependency : dependencies) {
                if (dependency == null) continue;
                sb.append(dependency).append(LS);
            }
            returnValue = sb.toString();
        }
        return returnValue;
    }
}

