/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Stream;
import org.microbean.helm.chart.HelmIgnorePathMatcher;
import org.microbean.helm.chart.StreamOrientedChartLoader;

public class DirectoryChartLoader
extends StreamOrientedChartLoader<Path> {
    private static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    private final FileVisitOption[] fileVisitOptions;

    public DirectoryChartLoader() {
        this(false);
    }

    public DirectoryChartLoader(boolean followSymlinks) {
        FileVisitOption[] fileVisitOptionArray;
        if (followSymlinks) {
            FileVisitOption[] fileVisitOptionArray2 = new FileVisitOption[1];
            fileVisitOptionArray = fileVisitOptionArray2;
            fileVisitOptionArray2[0] = FileVisitOption.FOLLOW_LINKS;
        } else {
            fileVisitOptionArray = EMPTY_FILE_VISIT_OPTION_ARRAY;
        }
        this.fileVisitOptions = fileVisitOptionArray;
    }

    @Override
    protected Iterable<? extends Map.Entry<? extends String, ? extends InputStream>> toNamedInputStreamEntries(Path path) throws IOException {
        Iterable<Map.Entry<String, InputStream>> returnValue = path == null || !Files.isDirectory(path, new LinkOption[0]) ? new StreamOrientedChartLoader.EmptyIterable() : new PathWalker(path, this.fileVisitOptions);
        return returnValue;
    }

    @Override
    public void close() throws IOException {
    }

    private static final class PathIterator
    implements Iterator<Map.Entry<String, InputStream>> {
        private final Path directoryParent;
        private final Iterator<? extends Path> pathIterator;
        private Map.Entry<String, InputStream> currentEntry;

        private PathIterator(Path directoryParent, Iterator<? extends Path> pathIterator) {
            Objects.requireNonNull(directoryParent);
            Objects.requireNonNull(pathIterator);
            if (!Files.isDirectory(directoryParent, new LinkOption[0])) {
                throw new IllegalArgumentException("!Files.isDirectory(directoryParent): " + directoryParent);
            }
            this.directoryParent = directoryParent;
            this.pathIterator = pathIterator;
        }

        @Override
        public final boolean hasNext() {
            if (this.currentEntry != null) {
                InputStream oldStream = this.currentEntry.getValue();
                if (oldStream != null) {
                    try {
                        oldStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.currentEntry = null;
            }
            return this.pathIterator != null && this.pathIterator.hasNext();
        }

        @Override
        public final Map.Entry<String, InputStream> next() {
            Path originalFile = this.pathIterator.next();
            assert (originalFile != null);
            assert (!Files.isDirectory(originalFile, new LinkOption[0]));
            Path relativeFile = this.directoryParent.relativize(originalFile);
            assert (relativeFile != null);
            String relativePathString = relativeFile.toString().replace('\\', '/');
            assert (relativePathString != null);
            try {
                this.currentEntry = new AbstractMap.SimpleImmutableEntry<String, BufferedInputStream>(relativePathString, new BufferedInputStream(Files.newInputStream(originalFile, new OpenOption[0])));
            }
            catch (IOException wrapMe) {
                throw (NoSuchElementException)new NoSuchElementException(wrapMe.getMessage()).initCause(wrapMe);
            }
            return this.currentEntry;
        }
    }

    private static final class PathWalker
    implements Iterable<Map.Entry<String, InputStream>> {
        private final Path directoryParent;
        private final Stream<? extends Path> pathStream;
        private final FileVisitOption[] fileVisitOptions;

        private PathWalker(Path directory, FileVisitOption[] fileVisitOptions) throws IOException {
            Stream<Path> pathStream;
            Objects.requireNonNull(directory);
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                throw new IllegalArgumentException("!Files.isDirectory(directory): " + directory);
            }
            Path directoryParent = directory.getParent();
            if (directoryParent == null) {
                throw new IllegalArgumentException("directory.getParent() == null");
            }
            this.directoryParent = directoryParent;
            this.fileVisitOptions = fileVisitOptions;
            Path helmIgnore = directory.resolve(".helmIgnore");
            assert (helmIgnore != null);
            if (!Files.exists(helmIgnore, new LinkOption[0])) {
                pathStream = Files.walk(directory, this.fileVisitOptions).filter(p -> p != null && !Files.isDirectory(p, new LinkOption[0]));
            } else {
                HelmIgnorePathMatcher helmIgnorePathMatcher = new HelmIgnorePathMatcher(helmIgnore);
                pathStream = Files.walk(directory, this.fileVisitOptions).filter(p -> p != null && !Files.isDirectory(p, new LinkOption[0]) && !helmIgnorePathMatcher.matches((Path)p));
            }
            this.pathStream = pathStream;
        }

        @Override
        public final Iterator<Map.Entry<String, InputStream>> iterator() {
            return new PathIterator(this.directoryParent, this.pathStream.iterator());
        }
    }
}

