/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm;

import hapi.services.tiller.ReleaseServiceGrpc;
import hapi.services.tiller.Tiller;
import hapi.version.VersionOuterClass;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigAware;
import io.fabric8.kubernetes.client.HttpClientAware;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.microbean.development.annotation.Issue;
import org.microbean.helm.TillerException;
import org.microbean.kubernetes.Pods;

public class Tiller
implements ConfigAware<Config>,
Closeable {
    public static final String VERSION = "2.8.2";
    public static final String DEFAULT_NAMESPACE = "kube-system";
    public static final int DEFAULT_PORT = 44134;
    public static final Map<String, String> DEFAULT_LABELS;
    public static final int MAX_MESSAGE_SIZE = 0x1400000;
    private static final Metadata metadata;
    private final Config config;
    private final LocalPortForward portForward;
    private final ManagedChannel channel;

    public Tiller(ManagedChannel channel) {
        Objects.requireNonNull(channel);
        this.config = null;
        this.portForward = null;
        this.channel = channel;
    }

    public Tiller(LocalPortForward portForward) {
        Objects.requireNonNull(portForward);
        this.config = null;
        this.portForward = null;
        this.channel = this.buildChannel(portForward);
    }

    public <T extends HttpClientAware & KubernetesClient> Tiller(T client) throws MalformedURLException {
        this(client, DEFAULT_NAMESPACE, 44134, DEFAULT_LABELS);
    }

    public <T extends HttpClientAware & KubernetesClient> Tiller(T client, String namespaceHousingTiller) throws MalformedURLException {
        this(client, namespaceHousingTiller, 44134, DEFAULT_LABELS);
    }

    public <T extends HttpClientAware & KubernetesClient> Tiller(T client, String namespaceHousingTiller, int tillerPort, Map<String, String> tillerLabels) throws MalformedURLException {
        OkHttpClient httpClient;
        Objects.requireNonNull(client);
        this.config = ((ConfigAware)client).getConfiguration();
        if (namespaceHousingTiller == null || namespaceHousingTiller.isEmpty()) {
            namespaceHousingTiller = DEFAULT_NAMESPACE;
        }
        if (tillerPort <= 0) {
            tillerPort = 44134;
        }
        if (tillerLabels == null) {
            tillerLabels = DEFAULT_LABELS;
        }
        if ((httpClient = client.getHttpClient()) == null) {
            throw new IllegalArgumentException("client", new IllegalStateException("client.getHttpClient() == null"));
        }
        Object portForward = null;
        this.portForward = Pods.forwardPort((OkHttpClient)httpClient, (Listable)((Listable)((NonNamespaceOperation)((KubernetesClient)client).pods().inNamespace(namespaceHousingTiller)).withLabels(tillerLabels)), (int)tillerPort);
        if (this.portForward == null) {
            throw new TillerException("Could not forward port to a Ready Tiller pod's port " + tillerPort + " in namespace " + namespaceHousingTiller + " with labels " + tillerLabels);
        }
        this.channel = this.buildChannel(this.portForward);
    }

    public Config getConfiguration() {
        return this.config;
    }

    @Issue(id="42", uri="https://github.com/microbean/microbean-helm/issues/42")
    protected @Issue(id="42", uri="https://github.com/microbean/microbean-helm/issues/42") ManagedChannel buildChannel(LocalPortForward portForward) {
        Objects.requireNonNull(portForward);
        @Issue(id="43", uri="https://github.com/microbean/microbean-helm/issues/43") InetAddress localAddress = portForward.getLocalAddress();
        if (localAddress == null) {
            throw new IllegalArgumentException("portForward", new IllegalStateException("portForward.getLocalAddress() == null"));
        }
        String hostAddress = localAddress.getHostAddress();
        if (hostAddress == null) {
            throw new IllegalArgumentException("portForward", new IllegalStateException("portForward.getLocalAddress().getHostAddress() == null"));
        }
        return ManagedChannelBuilder.forAddress((String)hostAddress, (int)portForward.getLocalPort()).idleTimeout(5L, TimeUnit.SECONDS).keepAliveTime(30L, TimeUnit.SECONDS).maxInboundMessageSize(0x1400000).usePlaintext(true).build();
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.shutdown();
        }
        if (this.portForward != null) {
            this.portForward.close();
        }
    }

    public ReleaseServiceGrpc.ReleaseServiceBlockingStub getReleaseServiceBlockingStub() {
        ReleaseServiceGrpc.ReleaseServiceBlockingStub returnValue = null;
        if (this.channel != null) {
            returnValue = (ReleaseServiceGrpc.ReleaseServiceBlockingStub)MetadataUtils.attachHeaders((AbstractStub)ReleaseServiceGrpc.newBlockingStub((Channel)this.channel), (Metadata)metadata);
        }
        return returnValue;
    }

    public ReleaseServiceGrpc.ReleaseServiceFutureStub getReleaseServiceFutureStub() {
        ReleaseServiceGrpc.ReleaseServiceFutureStub returnValue = null;
        if (this.channel != null) {
            returnValue = (ReleaseServiceGrpc.ReleaseServiceFutureStub)MetadataUtils.attachHeaders((AbstractStub)ReleaseServiceGrpc.newFutureStub((Channel)this.channel), (Metadata)metadata);
        }
        return returnValue;
    }

    public ReleaseServiceGrpc.ReleaseServiceStub getReleaseServiceStub() {
        ReleaseServiceGrpc.ReleaseServiceStub returnValue = null;
        if (this.channel != null) {
            returnValue = (ReleaseServiceGrpc.ReleaseServiceStub)MetadataUtils.attachHeaders((AbstractStub)ReleaseServiceGrpc.newStub((Channel)this.channel), (Metadata)metadata);
        }
        return returnValue;
    }

    public HealthGrpc.HealthBlockingStub getHealthBlockingStub() {
        HealthGrpc.HealthBlockingStub returnValue = null;
        if (this.channel != null) {
            returnValue = (HealthGrpc.HealthBlockingStub)MetadataUtils.attachHeaders((AbstractStub)HealthGrpc.newBlockingStub((Channel)this.channel), (Metadata)metadata);
        }
        return returnValue;
    }

    public HealthGrpc.HealthFutureStub getHealthFutureStub() {
        HealthGrpc.HealthFutureStub returnValue = null;
        if (this.channel != null) {
            returnValue = (HealthGrpc.HealthFutureStub)MetadataUtils.attachHeaders((AbstractStub)HealthGrpc.newFutureStub((Channel)this.channel), (Metadata)metadata);
        }
        return returnValue;
    }

    public HealthGrpc.HealthStub getHealthStub() {
        HealthGrpc.HealthStub returnValue = null;
        if (this.channel != null) {
            returnValue = (HealthGrpc.HealthStub)MetadataUtils.attachHeaders((AbstractStub)HealthGrpc.newStub((Channel)this.channel), (Metadata)metadata);
        }
        return returnValue;
    }

    public VersionOuterClass.VersionOrBuilder getVersion() throws IOException {
        ReleaseServiceGrpc.ReleaseServiceBlockingStub stub = this.getReleaseServiceBlockingStub();
        assert (stub != null);
        Tiller.GetVersionResponse response = stub.getVersion(null);
        assert (response != null);
        return response.getVersion();
    }

    static {
        metadata = new Metadata();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("name", "tiller");
        labels.put("app", "helm");
        DEFAULT_LABELS = Collections.unmodifiableMap(labels);
        metadata.put(Metadata.Key.of((String)"x-helm-api-client", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)VERSION);
    }
}

